package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTaskAssignRule invokes the qualitycheck.UpdateTaskAssignRule API synchronously
// api document: https://help.aliyun.com/api/qualitycheck/updatetaskassignrule.html
func (client *Client) UpdateTaskAssignRule(request *UpdateTaskAssignRuleRequest) (response *UpdateTaskAssignRuleResponse, err error) {
	response = CreateUpdateTaskAssignRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTaskAssignRuleWithChan invokes the qualitycheck.UpdateTaskAssignRule API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/updatetaskassignrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateTaskAssignRuleWithChan(request *UpdateTaskAssignRuleRequest) (<-chan *UpdateTaskAssignRuleResponse, <-chan error) {
	responseChan := make(chan *UpdateTaskAssignRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTaskAssignRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTaskAssignRuleWithCallback invokes the qualitycheck.UpdateTaskAssignRule API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/updatetaskassignrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateTaskAssignRuleWithCallback(request *UpdateTaskAssignRuleRequest, callback func(response *UpdateTaskAssignRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTaskAssignRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateTaskAssignRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTaskAssignRuleRequest is the request struct for api UpdateTaskAssignRule
type UpdateTaskAssignRuleRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// UpdateTaskAssignRuleResponse is the response struct for api UpdateTaskAssignRule
type UpdateTaskAssignRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateUpdateTaskAssignRuleRequest creates a request to invoke UpdateTaskAssignRule API
func CreateUpdateTaskAssignRuleRequest() (request *UpdateTaskAssignRuleRequest) {
	request = &UpdateTaskAssignRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "UpdateTaskAssignRule", "", "")
	return
}

// CreateUpdateTaskAssignRuleResponse creates a response to parse from UpdateTaskAssignRule response
func CreateUpdateTaskAssignRuleResponse() (response *UpdateTaskAssignRuleResponse) {
	response = &UpdateTaskAssignRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
