package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateShardingInstance invokes the r_kvstore.CreateShardingInstance API synchronously
// api document: https://help.aliyun.com/api/r-kvstore/createshardinginstance.html
func (client *Client) CreateShardingInstance(request *CreateShardingInstanceRequest) (response *CreateShardingInstanceResponse, err error) {
	response = CreateCreateShardingInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateShardingInstanceWithChan invokes the r_kvstore.CreateShardingInstance API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/createshardinginstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateShardingInstanceWithChan(request *CreateShardingInstanceRequest) (<-chan *CreateShardingInstanceResponse, <-chan error) {
	responseChan := make(chan *CreateShardingInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateShardingInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateShardingInstanceWithCallback invokes the r_kvstore.CreateShardingInstance API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/createshardinginstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateShardingInstanceWithCallback(request *CreateShardingInstanceRequest, callback func(response *CreateShardingInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateShardingInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreateShardingInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateShardingInstanceRequest is the request struct for api CreateShardingInstance
type CreateShardingInstanceRequest struct {
	*requests.RpcRequest
	ShardStorageQuantity  requests.Integer `position:"Query" name:"ShardStorageQuantity"`
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CouponNo              string           `position:"Query" name:"CouponNo"`
	NetworkType           string           `position:"Query" name:"NetworkType"`
	EngineVersion         string           `position:"Query" name:"EngineVersion"`
	Password              string           `position:"Query" name:"Password"`
	ShardReplicaClass     string           `position:"Query" name:"ShardReplicaClass"`
	SecurityToken         string           `position:"Query" name:"SecurityToken"`
	IncrementalBackupMode string           `position:"Query" name:"IncrementalBackupMode"`
	BusinessInfo          string           `position:"Query" name:"BusinessInfo"`
	Period                string           `position:"Query" name:"Period"`
	BackupId              string           `position:"Query" name:"BackupId"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	VSwitchId             string           `position:"Query" name:"VSwitchId"`
	PrivateIpAddress      string           `position:"Query" name:"PrivateIpAddress"`
	SecurityIPList        string           `position:"Query" name:"SecurityIPList"`
	InstanceName          string           `position:"Query" name:"InstanceName"`
	ZoneId                string           `position:"Query" name:"ZoneId"`
	ProxyQuantity         requests.Integer `position:"Query" name:"ProxyQuantity"`
	ProxyMode             string           `position:"Query" name:"ProxyMode"`
	NodeType              string           `position:"Query" name:"NodeType"`
	InstanceClass         string           `position:"Query" name:"InstanceClass"`
	Capacity              requests.Integer `position:"Query" name:"Capacity"`
	InstanceType          string           `position:"Query" name:"InstanceType"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	SrcDBInstanceId       string           `position:"Query" name:"SrcDBInstanceId"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	Token                 string           `position:"Query" name:"Token"`
	ShardQuantity         requests.Integer `position:"Query" name:"ShardQuantity"`
	ShardReplicaQuantity  requests.Integer `position:"Query" name:"ShardReplicaQuantity"`
	ArchitectureType      string           `position:"Query" name:"ArchitectureType"`
	VpcId                 string           `position:"Query" name:"VpcId"`
	RedisManagerClass     string           `position:"Query" name:"RedisManagerClass"`
	ChargeType            string           `position:"Query" name:"ChargeType"`
	Config                string           `position:"Query" name:"Config"`
}

// CreateShardingInstanceResponse is the response struct for api CreateShardingInstance
type CreateShardingInstanceResponse struct {
	*responses.BaseResponse
	RequestId  string                            `json:"RequestId" xml:"RequestId"`
	InstanceId string                            `json:"InstanceId" xml:"InstanceId"`
	OrderId    string                            `json:"OrderId" xml:"OrderId"`
	ShardList  ShardListInCreateShardingInstance `json:"ShardList" xml:"ShardList"`
}

// CreateCreateShardingInstanceRequest creates a request to invoke CreateShardingInstance API
func CreateCreateShardingInstanceRequest() (request *CreateShardingInstanceRequest) {
	request = &CreateShardingInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "CreateShardingInstance", "", "")
	return
}

// CreateCreateShardingInstanceResponse creates a response to parse from CreateShardingInstance response
func CreateCreateShardingInstanceResponse() (response *CreateShardingInstanceResponse) {
	response = &CreateShardingInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
