package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBInstanceConnectionString invokes the r_kvstore.ModifyDBInstanceConnectionString API synchronously
// api document: https://help.aliyun.com/api/r-kvstore/modifydbinstanceconnectionstring.html
func (client *Client) ModifyDBInstanceConnectionString(request *ModifyDBInstanceConnectionStringRequest) (response *ModifyDBInstanceConnectionStringResponse, err error) {
	response = CreateModifyDBInstanceConnectionStringResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBInstanceConnectionStringWithChan invokes the r_kvstore.ModifyDBInstanceConnectionString API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/modifydbinstanceconnectionstring.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyDBInstanceConnectionStringWithChan(request *ModifyDBInstanceConnectionStringRequest) (<-chan *ModifyDBInstanceConnectionStringResponse, <-chan error) {
	responseChan := make(chan *ModifyDBInstanceConnectionStringResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBInstanceConnectionString(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBInstanceConnectionStringWithCallback invokes the r_kvstore.ModifyDBInstanceConnectionString API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/modifydbinstanceconnectionstring.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyDBInstanceConnectionStringWithCallback(request *ModifyDBInstanceConnectionStringRequest, callback func(response *ModifyDBInstanceConnectionStringResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBInstanceConnectionStringResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBInstanceConnectionString(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBInstanceConnectionStringRequest is the request struct for api ModifyDBInstanceConnectionString
type ModifyDBInstanceConnectionStringRequest struct {
	*requests.RpcRequest
	ResourceOwnerId         requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken           string           `position:"Query" name:"SecurityToken"`
	DBInstanceId            string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount    string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount            string           `position:"Query" name:"OwnerAccount"`
	NewConnectionString     string           `position:"Query" name:"NewConnectionString"`
	OwnerId                 requests.Integer `position:"Query" name:"OwnerId"`
	IPType                  string           `position:"Query" name:"IPType"`
	CurrentConnectionString string           `position:"Query" name:"CurrentConnectionString"`
	Port                    string           `position:"Query" name:"Port"`
}

// ModifyDBInstanceConnectionStringResponse is the response struct for api ModifyDBInstanceConnectionString
type ModifyDBInstanceConnectionStringResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDBInstanceConnectionStringRequest creates a request to invoke ModifyDBInstanceConnectionString API
func CreateModifyDBInstanceConnectionStringRequest() (request *ModifyDBInstanceConnectionStringRequest) {
	request = &ModifyDBInstanceConnectionStringRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "ModifyDBInstanceConnectionString", "", "")
	return
}

// CreateModifyDBInstanceConnectionStringResponse creates a response to parse from ModifyDBInstanceConnectionString response
func CreateModifyDBInstanceConnectionStringResponse() (response *ModifyDBInstanceConnectionStringResponse) {
	response = &ModifyDBInstanceConnectionStringResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
