package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MuteAudio invokes the rtc.MuteAudio API synchronously
// api document: https://help.aliyun.com/api/rtc/muteaudio.html
func (client *Client) MuteAudio(request *MuteAudioRequest) (response *MuteAudioResponse, err error) {
	response = CreateMuteAudioResponse()
	err = client.DoAction(request, response)
	return
}

// MuteAudioWithChan invokes the rtc.MuteAudio API asynchronously
// api document: https://help.aliyun.com/api/rtc/muteaudio.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MuteAudioWithChan(request *MuteAudioRequest) (<-chan *MuteAudioResponse, <-chan error) {
	responseChan := make(chan *MuteAudioResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MuteAudio(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MuteAudioWithCallback invokes the rtc.MuteAudio API asynchronously
// api document: https://help.aliyun.com/api/rtc/muteaudio.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MuteAudioWithCallback(request *MuteAudioRequest, callback func(response *MuteAudioResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MuteAudioResponse
		var err error
		defer close(result)
		response, err = client.MuteAudio(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MuteAudioRequest is the request struct for api MuteAudio
type MuteAudioRequest struct {
	*requests.RpcRequest
	ParticipantIds *[]string        `position:"Query" name:"ParticipantIds"  type:"Repeated"`
	ConferenceId   string           `position:"Query" name:"ConferenceId"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	AppId          string           `position:"Query" name:"AppId"`
}

// MuteAudioResponse is the response struct for api MuteAudio
type MuteAudioResponse struct {
	*responses.BaseResponse
	RequestId    string                  `json:"RequestId" xml:"RequestId"`
	ConferenceId string                  `json:"ConferenceId" xml:"ConferenceId"`
	Participants ParticipantsInMuteAudio `json:"Participants" xml:"Participants"`
}

// CreateMuteAudioRequest creates a request to invoke MuteAudio API
func CreateMuteAudioRequest() (request *MuteAudioRequest) {
	request = &MuteAudioRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "MuteAudio", "", "")
	return
}

// CreateMuteAudioResponse creates a response to parse from MuteAudio response
func CreateMuteAudioResponse() (response *MuteAudioResponse) {
	response = &MuteAudioResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
