package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSagCidr invokes the smartag.DeleteSagCidr API synchronously
// api document: https://help.aliyun.com/api/smartag/deletesagcidr.html
func (client *Client) DeleteSagCidr(request *DeleteSagCidrRequest) (response *DeleteSagCidrResponse, err error) {
	response = CreateDeleteSagCidrResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSagCidrWithChan invokes the smartag.DeleteSagCidr API asynchronously
// api document: https://help.aliyun.com/api/smartag/deletesagcidr.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteSagCidrWithChan(request *DeleteSagCidrRequest) (<-chan *DeleteSagCidrResponse, <-chan error) {
	responseChan := make(chan *DeleteSagCidrResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSagCidr(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSagCidrWithCallback invokes the smartag.DeleteSagCidr API asynchronously
// api document: https://help.aliyun.com/api/smartag/deletesagcidr.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteSagCidrWithCallback(request *DeleteSagCidrRequest, callback func(response *DeleteSagCidrResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSagCidrResponse
		var err error
		defer close(result)
		response, err = client.DeleteSagCidr(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSagCidrRequest is the request struct for api DeleteSagCidr
type DeleteSagCidrRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Cidr                 string           `position:"Query" name:"Cidr"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// DeleteSagCidrResponse is the response struct for api DeleteSagCidr
type DeleteSagCidrResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteSagCidrRequest creates a request to invoke DeleteSagCidr API
func CreateDeleteSagCidrRequest() (request *DeleteSagCidrRequest) {
	request = &DeleteSagCidrRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DeleteSagCidr", "smartag", "openAPI")
	return
}

// CreateDeleteSagCidrResponse creates a response to parse from DeleteSagCidr response
func CreateDeleteSagCidrResponse() (response *DeleteSagCidrResponse) {
	response = &DeleteSagCidrResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
