package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePbrRules invokes the smartag.DescribePbrRules API synchronously
// api document: https://help.aliyun.com/api/smartag/describepbrrules.html
func (client *Client) DescribePbrRules(request *DescribePbrRulesRequest) (response *DescribePbrRulesResponse, err error) {
	response = CreateDescribePbrRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePbrRulesWithChan invokes the smartag.DescribePbrRules API asynchronously
// api document: https://help.aliyun.com/api/smartag/describepbrrules.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePbrRulesWithChan(request *DescribePbrRulesRequest) (<-chan *DescribePbrRulesResponse, <-chan error) {
	responseChan := make(chan *DescribePbrRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePbrRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePbrRulesWithCallback invokes the smartag.DescribePbrRules API asynchronously
// api document: https://help.aliyun.com/api/smartag/describepbrrules.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePbrRulesWithCallback(request *DescribePbrRulesRequest, callback func(response *DescribePbrRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePbrRulesResponse
		var err error
		defer close(result)
		response, err = client.DescribePbrRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePbrRulesRequest is the request struct for api DescribePbrRules
type DescribePbrRulesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           string           `position:"Query" name:"PageNumber"`
	PageSize             string           `position:"Query" name:"PageSize"`
	PbrInstanceId        string           `position:"Query" name:"PbrInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribePbrRulesResponse is the response struct for api DescribePbrRules
type DescribePbrRulesResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	TotalCount int      `json:"TotalCount" xml:"TotalCount"`
	PageNumber int      `json:"PageNumber" xml:"PageNumber"`
	PageSize   int      `json:"PageSize" xml:"PageSize"`
	PbrRules   PbrRules `json:"PbrRules" xml:"PbrRules"`
}

// CreateDescribePbrRulesRequest creates a request to invoke DescribePbrRules API
func CreateDescribePbrRulesRequest() (request *DescribePbrRulesRequest) {
	request = &DescribePbrRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribePbrRules", "smartag", "openAPI")
	return
}

// CreateDescribePbrRulesResponse creates a response to parse from DescribePbrRules response
func CreateDescribePbrRulesResponse() (response *DescribePbrRulesResponse) {
	response = &DescribePbrRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
