package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSmartAccessGatewayVersions invokes the smartag.DescribeSmartAccessGatewayVersions API synchronously
// api document: https://help.aliyun.com/api/smartag/describesmartaccessgatewayversions.html
func (client *Client) DescribeSmartAccessGatewayVersions(request *DescribeSmartAccessGatewayVersionsRequest) (response *DescribeSmartAccessGatewayVersionsResponse, err error) {
	response = CreateDescribeSmartAccessGatewayVersionsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSmartAccessGatewayVersionsWithChan invokes the smartag.DescribeSmartAccessGatewayVersions API asynchronously
// api document: https://help.aliyun.com/api/smartag/describesmartaccessgatewayversions.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSmartAccessGatewayVersionsWithChan(request *DescribeSmartAccessGatewayVersionsRequest) (<-chan *DescribeSmartAccessGatewayVersionsResponse, <-chan error) {
	responseChan := make(chan *DescribeSmartAccessGatewayVersionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSmartAccessGatewayVersions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSmartAccessGatewayVersionsWithCallback invokes the smartag.DescribeSmartAccessGatewayVersions API asynchronously
// api document: https://help.aliyun.com/api/smartag/describesmartaccessgatewayversions.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSmartAccessGatewayVersionsWithCallback(request *DescribeSmartAccessGatewayVersionsRequest, callback func(response *DescribeSmartAccessGatewayVersionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSmartAccessGatewayVersionsResponse
		var err error
		defer close(result)
		response, err = client.DescribeSmartAccessGatewayVersions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSmartAccessGatewayVersionsRequest is the request struct for api DescribeSmartAccessGatewayVersions
type DescribeSmartAccessGatewayVersionsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// DescribeSmartAccessGatewayVersionsResponse is the response struct for api DescribeSmartAccessGatewayVersions
type DescribeSmartAccessGatewayVersionsResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	SmartAGVersions SmartAGVersions `json:"SmartAGVersions" xml:"SmartAGVersions"`
}

// CreateDescribeSmartAccessGatewayVersionsRequest creates a request to invoke DescribeSmartAccessGatewayVersions API
func CreateDescribeSmartAccessGatewayVersionsRequest() (request *DescribeSmartAccessGatewayVersionsRequest) {
	request = &DescribeSmartAccessGatewayVersionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeSmartAccessGatewayVersions", "smartag", "openAPI")
	return
}

// CreateDescribeSmartAccessGatewayVersionsResponse creates a response to parse from DescribeSmartAccessGatewayVersions response
func CreateDescribeSmartAccessGatewayVersionsResponse() (response *DescribeSmartAccessGatewayVersionsResponse) {
	response = &DescribeSmartAccessGatewayVersionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
