package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetachNetworkOptimizationSags invokes the smartag.DetachNetworkOptimizationSags API synchronously
// api document: https://help.aliyun.com/api/smartag/detachnetworkoptimizationsags.html
func (client *Client) DetachNetworkOptimizationSags(request *DetachNetworkOptimizationSagsRequest) (response *DetachNetworkOptimizationSagsResponse, err error) {
	response = CreateDetachNetworkOptimizationSagsResponse()
	err = client.DoAction(request, response)
	return
}

// DetachNetworkOptimizationSagsWithChan invokes the smartag.DetachNetworkOptimizationSags API asynchronously
// api document: https://help.aliyun.com/api/smartag/detachnetworkoptimizationsags.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DetachNetworkOptimizationSagsWithChan(request *DetachNetworkOptimizationSagsRequest) (<-chan *DetachNetworkOptimizationSagsResponse, <-chan error) {
	responseChan := make(chan *DetachNetworkOptimizationSagsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetachNetworkOptimizationSags(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetachNetworkOptimizationSagsWithCallback invokes the smartag.DetachNetworkOptimizationSags API asynchronously
// api document: https://help.aliyun.com/api/smartag/detachnetworkoptimizationsags.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DetachNetworkOptimizationSagsWithCallback(request *DetachNetworkOptimizationSagsRequest, callback func(response *DetachNetworkOptimizationSagsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetachNetworkOptimizationSagsResponse
		var err error
		defer close(result)
		response, err = client.DetachNetworkOptimizationSags(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetachNetworkOptimizationSagsRequest is the request struct for api DetachNetworkOptimizationSags
type DetachNetworkOptimizationSagsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NetworkOptId         string           `position:"Query" name:"NetworkOptId"`
	SmartAGIds           *[]string        `position:"Query" name:"SmartAGIds"  type:"Repeated"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DetachNetworkOptimizationSagsResponse is the response struct for api DetachNetworkOptimizationSags
type DetachNetworkOptimizationSagsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDetachNetworkOptimizationSagsRequest creates a request to invoke DetachNetworkOptimizationSags API
func CreateDetachNetworkOptimizationSagsRequest() (request *DetachNetworkOptimizationSagsRequest) {
	request = &DetachNetworkOptimizationSagsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DetachNetworkOptimizationSags", "smartag", "openAPI")
	return
}

// CreateDetachNetworkOptimizationSagsResponse creates a response to parse from DetachNetworkOptimizationSags response
func CreateDetachNetworkOptimizationSagsResponse() (response *DetachNetworkOptimizationSagsResponse) {
	response = &DetachNetworkOptimizationSagsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
