package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySagRemoteAccess invokes the smartag.ModifySagRemoteAccess API synchronously
// api document: https://help.aliyun.com/api/smartag/modifysagremoteaccess.html
func (client *Client) ModifySagRemoteAccess(request *ModifySagRemoteAccessRequest) (response *ModifySagRemoteAccessResponse, err error) {
	response = CreateModifySagRemoteAccessResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySagRemoteAccessWithChan invokes the smartag.ModifySagRemoteAccess API asynchronously
// api document: https://help.aliyun.com/api/smartag/modifysagremoteaccess.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifySagRemoteAccessWithChan(request *ModifySagRemoteAccessRequest) (<-chan *ModifySagRemoteAccessResponse, <-chan error) {
	responseChan := make(chan *ModifySagRemoteAccessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySagRemoteAccess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySagRemoteAccessWithCallback invokes the smartag.ModifySagRemoteAccess API asynchronously
// api document: https://help.aliyun.com/api/smartag/modifysagremoteaccess.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifySagRemoteAccessWithCallback(request *ModifySagRemoteAccessRequest, callback func(response *ModifySagRemoteAccessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySagRemoteAccessResponse
		var err error
		defer close(result)
		response, err = client.ModifySagRemoteAccess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySagRemoteAccessRequest is the request struct for api ModifySagRemoteAccess
type ModifySagRemoteAccessRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	RemoteAccessIp       string           `position:"Query" name:"RemoteAccessIp"`
	SerialNumber         string           `position:"Query" name:"SerialNumber"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// ModifySagRemoteAccessResponse is the response struct for api ModifySagRemoteAccess
type ModifySagRemoteAccessResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	SerialNumber   string `json:"SerialNumber" xml:"SerialNumber"`
	RemoteAccessIp string `json:"RemoteAccessIp" xml:"RemoteAccessIp"`
}

// CreateModifySagRemoteAccessRequest creates a request to invoke ModifySagRemoteAccess API
func CreateModifySagRemoteAccessRequest() (request *ModifySagRemoteAccessRequest) {
	request = &ModifySagRemoteAccessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ModifySagRemoteAccess", "smartag", "openAPI")
	return
}

// CreateModifySagRemoteAccessResponse creates a response to parse from ModifySagRemoteAccess response
func CreateModifySagRemoteAccessResponse() (response *ModifySagRemoteAccessResponse) {
	response = &ModifySagRemoteAccessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
