package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnbindVbr invokes the smartag.UnbindVbr API synchronously
// api document: https://help.aliyun.com/api/smartag/unbindvbr.html
func (client *Client) UnbindVbr(request *UnbindVbrRequest) (response *UnbindVbrResponse, err error) {
	response = CreateUnbindVbrResponse()
	err = client.DoAction(request, response)
	return
}

// UnbindVbrWithChan invokes the smartag.UnbindVbr API asynchronously
// api document: https://help.aliyun.com/api/smartag/unbindvbr.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UnbindVbrWithChan(request *UnbindVbrRequest) (<-chan *UnbindVbrResponse, <-chan error) {
	responseChan := make(chan *UnbindVbrResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnbindVbr(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnbindVbrWithCallback invokes the smartag.UnbindVbr API asynchronously
// api document: https://help.aliyun.com/api/smartag/unbindvbr.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UnbindVbrWithCallback(request *UnbindVbrRequest, callback func(response *UnbindVbrResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnbindVbrResponse
		var err error
		defer close(result)
		response, err = client.UnbindVbr(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnbindVbrRequest is the request struct for api UnbindVbr
type UnbindVbrRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	VbrId                string           `position:"Query" name:"VbrId"`
	VbrRegionId          string           `position:"Query" name:"VbrRegionId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// UnbindVbrResponse is the response struct for api UnbindVbr
type UnbindVbrResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUnbindVbrRequest creates a request to invoke UnbindVbr API
func CreateUnbindVbrRequest() (request *UnbindVbrRequest) {
	request = &UnbindVbrRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "UnbindVbr", "smartag", "openAPI")
	return
}

// CreateUnbindVbrResponse creates a response to parse from UnbindVbr response
func CreateUnbindVbrResponse() (response *UnbindVbrResponse) {
	response = &UnbindVbrResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
