package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetWatermark invokes the vod.GetWatermark API synchronously
// api document: https://help.aliyun.com/api/vod/getwatermark.html
func (client *Client) GetWatermark(request *GetWatermarkRequest) (response *GetWatermarkResponse, err error) {
	response = CreateGetWatermarkResponse()
	err = client.DoAction(request, response)
	return
}

// GetWatermarkWithChan invokes the vod.GetWatermark API asynchronously
// api document: https://help.aliyun.com/api/vod/getwatermark.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetWatermarkWithChan(request *GetWatermarkRequest) (<-chan *GetWatermarkResponse, <-chan error) {
	responseChan := make(chan *GetWatermarkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetWatermark(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetWatermarkWithCallback invokes the vod.GetWatermark API asynchronously
// api document: https://help.aliyun.com/api/vod/getwatermark.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetWatermarkWithCallback(request *GetWatermarkRequest, callback func(response *GetWatermarkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetWatermarkResponse
		var err error
		defer close(result)
		response, err = client.GetWatermark(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetWatermarkRequest is the request struct for api GetWatermark
type GetWatermarkRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	WatermarkId          string           `position:"Query" name:"WatermarkId"`
}

// GetWatermarkResponse is the response struct for api GetWatermark
type GetWatermarkResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	WatermarkInfo WatermarkInfo `json:"WatermarkInfo" xml:"WatermarkInfo"`
}

// CreateGetWatermarkRequest creates a request to invoke GetWatermark API
func CreateGetWatermarkRequest() (request *GetWatermarkRequest) {
	request = &GetWatermarkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "GetWatermark", "vod", "openAPI")
	return
}

// CreateGetWatermarkResponse creates a response to parse from GetWatermark response
func CreateGetWatermarkResponse() (response *GetWatermarkResponse) {
	response = &GetWatermarkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
