package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteBgpNetwork invokes the vpc.DeleteBgpNetwork API synchronously
// api document: https://help.aliyun.com/api/vpc/deletebgpnetwork.html
func (client *Client) DeleteBgpNetwork(request *DeleteBgpNetworkRequest) (response *DeleteBgpNetworkResponse, err error) {
	response = CreateDeleteBgpNetworkResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteBgpNetworkWithChan invokes the vpc.DeleteBgpNetwork API asynchronously
// api document: https://help.aliyun.com/api/vpc/deletebgpnetwork.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteBgpNetworkWithChan(request *DeleteBgpNetworkRequest) (<-chan *DeleteBgpNetworkResponse, <-chan error) {
	responseChan := make(chan *DeleteBgpNetworkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteBgpNetwork(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteBgpNetworkWithCallback invokes the vpc.DeleteBgpNetwork API asynchronously
// api document: https://help.aliyun.com/api/vpc/deletebgpnetwork.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteBgpNetworkWithCallback(request *DeleteBgpNetworkRequest, callback func(response *DeleteBgpNetworkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteBgpNetworkResponse
		var err error
		defer close(result)
		response, err = client.DeleteBgpNetwork(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteBgpNetworkRequest is the request struct for api DeleteBgpNetwork
type DeleteBgpNetworkRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	RouterId             string           `position:"Query" name:"RouterId"`
	DstCidrBlock         string           `position:"Query" name:"DstCidrBlock"`
}

// DeleteBgpNetworkResponse is the response struct for api DeleteBgpNetwork
type DeleteBgpNetworkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteBgpNetworkRequest creates a request to invoke DeleteBgpNetwork API
func CreateDeleteBgpNetworkRequest() (request *DeleteBgpNetworkRequest) {
	request = &DeleteBgpNetworkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteBgpNetwork", "vpc", "openAPI")
	return
}

// CreateDeleteBgpNetworkResponse creates a response to parse from DeleteBgpNetwork response
func CreateDeleteBgpNetworkResponse() (response *DeleteBgpNetworkResponse) {
	response = &DeleteBgpNetworkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
