package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteExpressCloudConnection invokes the vpc.DeleteExpressCloudConnection API synchronously
// api document: https://help.aliyun.com/api/vpc/deleteexpresscloudconnection.html
func (client *Client) DeleteExpressCloudConnection(request *DeleteExpressCloudConnectionRequest) (response *DeleteExpressCloudConnectionResponse, err error) {
	response = CreateDeleteExpressCloudConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteExpressCloudConnectionWithChan invokes the vpc.DeleteExpressCloudConnection API asynchronously
// api document: https://help.aliyun.com/api/vpc/deleteexpresscloudconnection.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteExpressCloudConnectionWithChan(request *DeleteExpressCloudConnectionRequest) (<-chan *DeleteExpressCloudConnectionResponse, <-chan error) {
	responseChan := make(chan *DeleteExpressCloudConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteExpressCloudConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteExpressCloudConnectionWithCallback invokes the vpc.DeleteExpressCloudConnection API asynchronously
// api document: https://help.aliyun.com/api/vpc/deleteexpresscloudconnection.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteExpressCloudConnectionWithCallback(request *DeleteExpressCloudConnectionRequest, callback func(response *DeleteExpressCloudConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteExpressCloudConnectionResponse
		var err error
		defer close(result)
		response, err = client.DeleteExpressCloudConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteExpressCloudConnectionRequest is the request struct for api DeleteExpressCloudConnection
type DeleteExpressCloudConnectionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	EccId                string           `position:"Query" name:"EccId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteExpressCloudConnectionResponse is the response struct for api DeleteExpressCloudConnection
type DeleteExpressCloudConnectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteExpressCloudConnectionRequest creates a request to invoke DeleteExpressCloudConnection API
func CreateDeleteExpressCloudConnectionRequest() (request *DeleteExpressCloudConnectionRequest) {
	request = &DeleteExpressCloudConnectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteExpressCloudConnection", "vpc", "openAPI")
	return
}

// CreateDeleteExpressCloudConnectionResponse creates a response to parse from DeleteExpressCloudConnection response
func CreateDeleteExpressCloudConnectionResponse() (response *DeleteExpressCloudConnectionResponse) {
	response = &DeleteExpressCloudConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
