// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/asset/v1/asset_service.proto

package asset

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Asset content type.
type ContentType int32

const (
	// Unspecified content type.
	ContentType_CONTENT_TYPE_UNSPECIFIED ContentType = 0
	// Resource metadata.
	ContentType_RESOURCE ContentType = 1
	// The actual IAM policy set on a resource.
	ContentType_IAM_POLICY ContentType = 2
	// The Cloud Organization Policy set on an asset.
	ContentType_ORG_POLICY ContentType = 4
	// The Cloud Access context mananger Policy set on an asset.
	ContentType_ACCESS_POLICY ContentType = 5
)

var ContentType_name = map[int32]string{
	0: "CONTENT_TYPE_UNSPECIFIED",
	1: "RESOURCE",
	2: "IAM_POLICY",
	4: "ORG_POLICY",
	5: "ACCESS_POLICY",
}

var ContentType_value = map[string]int32{
	"CONTENT_TYPE_UNSPECIFIED": 0,
	"RESOURCE":                 1,
	"IAM_POLICY":               2,
	"ORG_POLICY":               4,
	"ACCESS_POLICY":            5,
}

func (x ContentType) String() string {
	return proto.EnumName(ContentType_name, int32(x))
}

func (ContentType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5104159f18b2092a, []int{0}
}

// Export asset request.
type ExportAssetsRequest struct {
	// Required. The relative name of the root asset. This can only be an
	// organization number (such as "organizations/123"), a project ID (such as
	// "projects/my-project-id"), or a project number (such as "projects/12345"),
	// or a folder number (such as "folders/123").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Timestamp to take an asset snapshot. This can only be set to a timestamp
	// between 2018-10-02 UTC (inclusive) and the current time. If not specified,
	// the current time will be used. Due to delays in resource data collection
	// and indexing, there is a volatile window during which running the same
	// query may get different results.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// A list of asset types of which to take a snapshot for. For example:
	// "compute.googleapis.com/Disk". If specified, only matching assets will be
	// returned. See [Introduction to Cloud Asset
	// Inventory](https://cloud.google.com/asset-inventory/docs/overview)
	// for all supported asset types.
	AssetTypes []string `protobuf:"bytes,3,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Asset content type. If not specified, no content but the asset name will be
	// returned.
	ContentType ContentType `protobuf:"varint,4,opt,name=content_type,json=contentType,proto3,enum=google.cloud.asset.v1.ContentType" json:"content_type,omitempty"`
	// Required. Output configuration indicating where the results will be output
	// to. All results will be in newline delimited JSON format.
	OutputConfig         *OutputConfig `protobuf:"bytes,5,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ExportAssetsRequest) Reset()         { *m = ExportAssetsRequest{} }
func (m *ExportAssetsRequest) String() string { return proto.CompactTextString(m) }
func (*ExportAssetsRequest) ProtoMessage()    {}
func (*ExportAssetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5104159f18b2092a, []int{0}
}

func (m *ExportAssetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportAssetsRequest.Unmarshal(m, b)
}
func (m *ExportAssetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportAssetsRequest.Marshal(b, m, deterministic)
}
func (m *ExportAssetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportAssetsRequest.Merge(m, src)
}
func (m *ExportAssetsRequest) XXX_Size() int {
	return xxx_messageInfo_ExportAssetsRequest.Size(m)
}
func (m *ExportAssetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportAssetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportAssetsRequest proto.InternalMessageInfo

func (m *ExportAssetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ExportAssetsRequest) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *ExportAssetsRequest) GetAssetTypes() []string {
	if m != nil {
		return m.AssetTypes
	}
	return nil
}

func (m *ExportAssetsRequest) GetContentType() ContentType {
	if m != nil {
		return m.ContentType
	}
	return ContentType_CONTENT_TYPE_UNSPECIFIED
}

func (m *ExportAssetsRequest) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// The export asset response. This message is returned by the
// [google.longrunning.Operations.GetOperation][google.longrunning.Operations.GetOperation] method in the returned
// [google.longrunning.Operation.response][google.longrunning.Operation.response] field.
type ExportAssetsResponse struct {
	// Time the snapshot was taken.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Output configuration indicating where the results were output to.
	// All results are in JSON format.
	OutputConfig         *OutputConfig `protobuf:"bytes,2,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ExportAssetsResponse) Reset()         { *m = ExportAssetsResponse{} }
func (m *ExportAssetsResponse) String() string { return proto.CompactTextString(m) }
func (*ExportAssetsResponse) ProtoMessage()    {}
func (*ExportAssetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5104159f18b2092a, []int{1}
}

func (m *ExportAssetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportAssetsResponse.Unmarshal(m, b)
}
func (m *ExportAssetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportAssetsResponse.Marshal(b, m, deterministic)
}
func (m *ExportAssetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportAssetsResponse.Merge(m, src)
}
func (m *ExportAssetsResponse) XXX_Size() int {
	return xxx_messageInfo_ExportAssetsResponse.Size(m)
}
func (m *ExportAssetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportAssetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExportAssetsResponse proto.InternalMessageInfo

func (m *ExportAssetsResponse) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *ExportAssetsResponse) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Batch get assets history request.
type BatchGetAssetsHistoryRequest struct {
	// Required. The relative name of the root asset. It can only be an
	// organization number (such as "organizations/123"), a project ID (such as
	// "projects/my-project-id")", or a project number (such as "projects/12345").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A list of the full names of the assets. For example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
	// See [Resource
	// Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// and [Resource Name
	// Format](https://cloud.google.com/asset-inventory/docs/resource-name-format)
	// for more info.
	//
	// The request becomes a no-op if the asset name list is empty, and the max
	// size of the asset name list is 100 in one request.
	AssetNames []string `protobuf:"bytes,2,rep,name=asset_names,json=assetNames,proto3" json:"asset_names,omitempty"`
	// Optional. The content type.
	ContentType ContentType `protobuf:"varint,3,opt,name=content_type,json=contentType,proto3,enum=google.cloud.asset.v1.ContentType" json:"content_type,omitempty"`
	// Optional. The time window for the asset history. Both start_time and
	// end_time are optional and if set, it must be after 2018-10-02 UTC. If
	// end_time is not set, it is default to current timestamp. If start_time is
	// not set, the snapshot of the assets at end_time will be returned. The
	// returned results contain all temporal assets whose time window overlap with
	// read_time_window.
	ReadTimeWindow       *TimeWindow `protobuf:"bytes,4,opt,name=read_time_window,json=readTimeWindow,proto3" json:"read_time_window,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *BatchGetAssetsHistoryRequest) Reset()         { *m = BatchGetAssetsHistoryRequest{} }
func (m *BatchGetAssetsHistoryRequest) String() string { return proto.CompactTextString(m) }
func (*BatchGetAssetsHistoryRequest) ProtoMessage()    {}
func (*BatchGetAssetsHistoryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5104159f18b2092a, []int{2}
}

func (m *BatchGetAssetsHistoryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchGetAssetsHistoryRequest.Unmarshal(m, b)
}
func (m *BatchGetAssetsHistoryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchGetAssetsHistoryRequest.Marshal(b, m, deterministic)
}
func (m *BatchGetAssetsHistoryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchGetAssetsHistoryRequest.Merge(m, src)
}
func (m *BatchGetAssetsHistoryRequest) XXX_Size() int {
	return xxx_messageInfo_BatchGetAssetsHistoryRequest.Size(m)
}
func (m *BatchGetAssetsHistoryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchGetAssetsHistoryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchGetAssetsHistoryRequest proto.InternalMessageInfo

func (m *BatchGetAssetsHistoryRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchGetAssetsHistoryRequest) GetAssetNames() []string {
	if m != nil {
		return m.AssetNames
	}
	return nil
}

func (m *BatchGetAssetsHistoryRequest) GetContentType() ContentType {
	if m != nil {
		return m.ContentType
	}
	return ContentType_CONTENT_TYPE_UNSPECIFIED
}

func (m *BatchGetAssetsHistoryRequest) GetReadTimeWindow() *TimeWindow {
	if m != nil {
		return m.ReadTimeWindow
	}
	return nil
}

// Batch get assets history response.
type BatchGetAssetsHistoryResponse struct {
	// A list of assets with valid time windows.
	Assets               []*TemporalAsset `protobuf:"bytes,1,rep,name=assets,proto3" json:"assets,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *BatchGetAssetsHistoryResponse) Reset()         { *m = BatchGetAssetsHistoryResponse{} }
func (m *BatchGetAssetsHistoryResponse) String() string { return proto.CompactTextString(m) }
func (*BatchGetAssetsHistoryResponse) ProtoMessage()    {}
func (*BatchGetAssetsHistoryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5104159f18b2092a, []int{3}
}

func (m *BatchGetAssetsHistoryResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchGetAssetsHistoryResponse.Unmarshal(m, b)
}
func (m *BatchGetAssetsHistoryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchGetAssetsHistoryResponse.Marshal(b, m, deterministic)
}
func (m *BatchGetAssetsHistoryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchGetAssetsHistoryResponse.Merge(m, src)
}
func (m *BatchGetAssetsHistoryResponse) XXX_Size() int {
	return xxx_messageInfo_BatchGetAssetsHistoryResponse.Size(m)
}
func (m *BatchGetAssetsHistoryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchGetAssetsHistoryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchGetAssetsHistoryResponse proto.InternalMessageInfo

func (m *BatchGetAssetsHistoryResponse) GetAssets() []*TemporalAsset {
	if m != nil {
		return m.Assets
	}
	return nil
}

// Create asset feed request.
type CreateFeedRequest struct {
	// Required. The name of the project/folder/organization where this feed
	// should be created in. It can only be an organization number (such as
	// "organizations/123"), a folder number (such as "folders/123"), a project ID
	// (such as "projects/my-project-id")", or a project number (such as
	// "projects/12345").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. This is the client-assigned asset feed identifier and it needs to
	// be unique under a specific parent project/folder/organization.
	FeedId string `protobuf:"bytes,2,opt,name=feed_id,json=feedId,proto3" json:"feed_id,omitempty"`
	// Required. The feed details. The field `name` must be empty and it will be generated
	// in the format of:
	// projects/project_number/feeds/feed_id
	// folders/folder_number/feeds/feed_id
	// organizations/organization_number/feeds/feed_id
	Feed                 *Feed    `protobuf:"bytes,3,opt,name=feed,proto3" json:"feed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateFeedRequest) Reset()         { *m = CreateFeedRequest{} }
func (m *CreateFeedRequest) String() string { return proto.CompactTextString(m) }
func (*CreateFeedRequest) ProtoMessage()    {}
func (*CreateFeedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5104159f18b2092a, []int{4}
}

func (m *CreateFeedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFeedRequest.Unmarshal(m, b)
}
func (m *CreateFeedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFeedRequest.Marshal(b, m, deterministic)
}
func (m *CreateFeedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFeedRequest.Merge(m, src)
}
func (m *CreateFeedRequest) XXX_Size() int {
	return xxx_messageInfo_CreateFeedRequest.Size(m)
}
func (m *CreateFeedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFeedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFeedRequest proto.InternalMessageInfo

func (m *CreateFeedRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateFeedRequest) GetFeedId() string {
	if m != nil {
		return m.FeedId
	}
	return ""
}

func (m *CreateFeedRequest) GetFeed() *Feed {
	if m != nil {
		return m.Feed
	}
	return nil
}

// Get asset feed request.
type GetFeedRequest struct {
	// Required. The name of the Feed and it must be in the format of:
	// projects/project_number/feeds/feed_id
	// folders/folder_number/feeds/feed_id
	// organizations/organization_number/feeds/feed_id
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetFeedRequest) Reset()         { *m = GetFeedRequest{} }
func (m *GetFeedRequest) String() string { return proto.CompactTextString(m) }
func (*GetFeedRequest) ProtoMessage()    {}
func (*GetFeedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5104159f18b2092a, []int{5}
}

func (m *GetFeedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetFeedRequest.Unmarshal(m, b)
}
func (m *GetFeedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetFeedRequest.Marshal(b, m, deterministic)
}
func (m *GetFeedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetFeedRequest.Merge(m, src)
}
func (m *GetFeedRequest) XXX_Size() int {
	return xxx_messageInfo_GetFeedRequest.Size(m)
}
func (m *GetFeedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetFeedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetFeedRequest proto.InternalMessageInfo

func (m *GetFeedRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// List asset feeds request.
type ListFeedsRequest struct {
	// Required. The parent project/folder/organization whose feeds are to be
	// listed. It can only be using project/folder/organization number (such as
	// "folders/12345")", or a project ID (such as "projects/my-project-id").
	Parent               string   `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFeedsRequest) Reset()         { *m = ListFeedsRequest{} }
func (m *ListFeedsRequest) String() string { return proto.CompactTextString(m) }
func (*ListFeedsRequest) ProtoMessage()    {}
func (*ListFeedsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5104159f18b2092a, []int{6}
}

func (m *ListFeedsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFeedsRequest.Unmarshal(m, b)
}
func (m *ListFeedsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFeedsRequest.Marshal(b, m, deterministic)
}
func (m *ListFeedsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFeedsRequest.Merge(m, src)
}
func (m *ListFeedsRequest) XXX_Size() int {
	return xxx_messageInfo_ListFeedsRequest.Size(m)
}
func (m *ListFeedsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFeedsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListFeedsRequest proto.InternalMessageInfo

func (m *ListFeedsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

type ListFeedsResponse struct {
	// A list of feeds.
	Feeds                []*Feed  `protobuf:"bytes,1,rep,name=feeds,proto3" json:"feeds,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFeedsResponse) Reset()         { *m = ListFeedsResponse{} }
func (m *ListFeedsResponse) String() string { return proto.CompactTextString(m) }
func (*ListFeedsResponse) ProtoMessage()    {}
func (*ListFeedsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5104159f18b2092a, []int{7}
}

func (m *ListFeedsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFeedsResponse.Unmarshal(m, b)
}
func (m *ListFeedsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFeedsResponse.Marshal(b, m, deterministic)
}
func (m *ListFeedsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFeedsResponse.Merge(m, src)
}
func (m *ListFeedsResponse) XXX_Size() int {
	return xxx_messageInfo_ListFeedsResponse.Size(m)
}
func (m *ListFeedsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFeedsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListFeedsResponse proto.InternalMessageInfo

func (m *ListFeedsResponse) GetFeeds() []*Feed {
	if m != nil {
		return m.Feeds
	}
	return nil
}

// Update asset feed request.
type UpdateFeedRequest struct {
	// Required. The new values of feed details. It must match an existing feed and the
	// field `name` must be in the format of:
	// projects/project_number/feeds/feed_id or
	// folders/folder_number/feeds/feed_id or
	// organizations/organization_number/feeds/feed_id.
	Feed *Feed `protobuf:"bytes,1,opt,name=feed,proto3" json:"feed,omitempty"`
	// Required. Only updates the `feed` fields indicated by this mask.
	// The field mask must not be empty, and it must not contain fields that
	// are immutable or only set by the server.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateFeedRequest) Reset()         { *m = UpdateFeedRequest{} }
func (m *UpdateFeedRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateFeedRequest) ProtoMessage()    {}
func (*UpdateFeedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5104159f18b2092a, []int{8}
}

func (m *UpdateFeedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateFeedRequest.Unmarshal(m, b)
}
func (m *UpdateFeedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateFeedRequest.Marshal(b, m, deterministic)
}
func (m *UpdateFeedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateFeedRequest.Merge(m, src)
}
func (m *UpdateFeedRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateFeedRequest.Size(m)
}
func (m *UpdateFeedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateFeedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateFeedRequest proto.InternalMessageInfo

func (m *UpdateFeedRequest) GetFeed() *Feed {
	if m != nil {
		return m.Feed
	}
	return nil
}

func (m *UpdateFeedRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type DeleteFeedRequest struct {
	// Required. The name of the feed and it must be in the format of:
	// projects/project_number/feeds/feed_id
	// folders/folder_number/feeds/feed_id
	// organizations/organization_number/feeds/feed_id
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteFeedRequest) Reset()         { *m = DeleteFeedRequest{} }
func (m *DeleteFeedRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteFeedRequest) ProtoMessage()    {}
func (*DeleteFeedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5104159f18b2092a, []int{9}
}

func (m *DeleteFeedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteFeedRequest.Unmarshal(m, b)
}
func (m *DeleteFeedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteFeedRequest.Marshal(b, m, deterministic)
}
func (m *DeleteFeedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteFeedRequest.Merge(m, src)
}
func (m *DeleteFeedRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteFeedRequest.Size(m)
}
func (m *DeleteFeedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteFeedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteFeedRequest proto.InternalMessageInfo

func (m *DeleteFeedRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Output configuration for export assets destination.
type OutputConfig struct {
	// Asset export destination.
	//
	// Types that are valid to be assigned to Destination:
	//	*OutputConfig_GcsDestination
	//	*OutputConfig_BigqueryDestination
	Destination          isOutputConfig_Destination `protobuf_oneof:"destination"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *OutputConfig) Reset()         { *m = OutputConfig{} }
func (m *OutputConfig) String() string { return proto.CompactTextString(m) }
func (*OutputConfig) ProtoMessage()    {}
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_5104159f18b2092a, []int{10}
}

func (m *OutputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OutputConfig.Unmarshal(m, b)
}
func (m *OutputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OutputConfig.Marshal(b, m, deterministic)
}
func (m *OutputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputConfig.Merge(m, src)
}
func (m *OutputConfig) XXX_Size() int {
	return xxx_messageInfo_OutputConfig.Size(m)
}
func (m *OutputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_OutputConfig proto.InternalMessageInfo

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination struct {
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

type OutputConfig_BigqueryDestination struct {
	BigqueryDestination *BigQueryDestination `protobuf:"bytes,2,opt,name=bigquery_destination,json=bigqueryDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination) isOutputConfig_Destination() {}

func (*OutputConfig_BigqueryDestination) isOutputConfig_Destination() {}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *OutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := m.GetDestination().(*OutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

func (m *OutputConfig) GetBigqueryDestination() *BigQueryDestination {
	if x, ok := m.GetDestination().(*OutputConfig_BigqueryDestination); ok {
		return x.BigqueryDestination
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OutputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OutputConfig_GcsDestination)(nil),
		(*OutputConfig_BigqueryDestination)(nil),
	}
}

// A Cloud Storage location.
type GcsDestination struct {
	// Required.
	//
	// Types that are valid to be assigned to ObjectUri:
	//	*GcsDestination_Uri
	//	*GcsDestination_UriPrefix
	ObjectUri            isGcsDestination_ObjectUri `protobuf_oneof:"object_uri"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *GcsDestination) Reset()         { *m = GcsDestination{} }
func (m *GcsDestination) String() string { return proto.CompactTextString(m) }
func (*GcsDestination) ProtoMessage()    {}
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_5104159f18b2092a, []int{11}
}

func (m *GcsDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsDestination.Unmarshal(m, b)
}
func (m *GcsDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsDestination.Marshal(b, m, deterministic)
}
func (m *GcsDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsDestination.Merge(m, src)
}
func (m *GcsDestination) XXX_Size() int {
	return xxx_messageInfo_GcsDestination.Size(m)
}
func (m *GcsDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsDestination.DiscardUnknown(m)
}

var xxx_messageInfo_GcsDestination proto.InternalMessageInfo

type isGcsDestination_ObjectUri interface {
	isGcsDestination_ObjectUri()
}

type GcsDestination_Uri struct {
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3,oneof"`
}

type GcsDestination_UriPrefix struct {
	UriPrefix string `protobuf:"bytes,2,opt,name=uri_prefix,json=uriPrefix,proto3,oneof"`
}

func (*GcsDestination_Uri) isGcsDestination_ObjectUri() {}

func (*GcsDestination_UriPrefix) isGcsDestination_ObjectUri() {}

func (m *GcsDestination) GetObjectUri() isGcsDestination_ObjectUri {
	if m != nil {
		return m.ObjectUri
	}
	return nil
}

func (m *GcsDestination) GetUri() string {
	if x, ok := m.GetObjectUri().(*GcsDestination_Uri); ok {
		return x.Uri
	}
	return ""
}

func (m *GcsDestination) GetUriPrefix() string {
	if x, ok := m.GetObjectUri().(*GcsDestination_UriPrefix); ok {
		return x.UriPrefix
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GcsDestination) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GcsDestination_Uri)(nil),
		(*GcsDestination_UriPrefix)(nil),
	}
}

// A BigQuery destination.
type BigQueryDestination struct {
	// Required. The BigQuery dataset in format
	// "projects/projectId/datasets/datasetId", to which the snapshot result
	// should be exported. If this dataset does not exist, the export call returns
	// an error.
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Required. The BigQuery table to which the snapshot result should be
	// written. If this table does not exist, a new table with the given name
	// will be created.
	Table string `protobuf:"bytes,2,opt,name=table,proto3" json:"table,omitempty"`
	// If the destination table already exists and this flag is `TRUE`, the
	// table will be overwritten by the contents of assets snapshot. If the flag
	// is not set and the destination table already exists, the export call
	// returns an error.
	Force                bool     `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BigQueryDestination) Reset()         { *m = BigQueryDestination{} }
func (m *BigQueryDestination) String() string { return proto.CompactTextString(m) }
func (*BigQueryDestination) ProtoMessage()    {}
func (*BigQueryDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_5104159f18b2092a, []int{12}
}

func (m *BigQueryDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BigQueryDestination.Unmarshal(m, b)
}
func (m *BigQueryDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BigQueryDestination.Marshal(b, m, deterministic)
}
func (m *BigQueryDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BigQueryDestination.Merge(m, src)
}
func (m *BigQueryDestination) XXX_Size() int {
	return xxx_messageInfo_BigQueryDestination.Size(m)
}
func (m *BigQueryDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_BigQueryDestination.DiscardUnknown(m)
}

var xxx_messageInfo_BigQueryDestination proto.InternalMessageInfo

func (m *BigQueryDestination) GetDataset() string {
	if m != nil {
		return m.Dataset
	}
	return ""
}

func (m *BigQueryDestination) GetTable() string {
	if m != nil {
		return m.Table
	}
	return ""
}

func (m *BigQueryDestination) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

// A Cloud Pubsub destination.
type PubsubDestination struct {
	// The name of the Cloud Pub/Sub topic to publish to.
	// For example: `projects/PROJECT_ID/topics/TOPIC_ID`.
	Topic                string   `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PubsubDestination) Reset()         { *m = PubsubDestination{} }
func (m *PubsubDestination) String() string { return proto.CompactTextString(m) }
func (*PubsubDestination) ProtoMessage()    {}
func (*PubsubDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_5104159f18b2092a, []int{13}
}

func (m *PubsubDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PubsubDestination.Unmarshal(m, b)
}
func (m *PubsubDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PubsubDestination.Marshal(b, m, deterministic)
}
func (m *PubsubDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PubsubDestination.Merge(m, src)
}
func (m *PubsubDestination) XXX_Size() int {
	return xxx_messageInfo_PubsubDestination.Size(m)
}
func (m *PubsubDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_PubsubDestination.DiscardUnknown(m)
}

var xxx_messageInfo_PubsubDestination proto.InternalMessageInfo

func (m *PubsubDestination) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

// Output configuration for asset feed destination.
type FeedOutputConfig struct {
	// Asset feed destination.
	//
	// Types that are valid to be assigned to Destination:
	//	*FeedOutputConfig_PubsubDestination
	Destination          isFeedOutputConfig_Destination `protobuf_oneof:"destination"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *FeedOutputConfig) Reset()         { *m = FeedOutputConfig{} }
func (m *FeedOutputConfig) String() string { return proto.CompactTextString(m) }
func (*FeedOutputConfig) ProtoMessage()    {}
func (*FeedOutputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_5104159f18b2092a, []int{14}
}

func (m *FeedOutputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FeedOutputConfig.Unmarshal(m, b)
}
func (m *FeedOutputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FeedOutputConfig.Marshal(b, m, deterministic)
}
func (m *FeedOutputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FeedOutputConfig.Merge(m, src)
}
func (m *FeedOutputConfig) XXX_Size() int {
	return xxx_messageInfo_FeedOutputConfig.Size(m)
}
func (m *FeedOutputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_FeedOutputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_FeedOutputConfig proto.InternalMessageInfo

type isFeedOutputConfig_Destination interface {
	isFeedOutputConfig_Destination()
}

type FeedOutputConfig_PubsubDestination struct {
	PubsubDestination *PubsubDestination `protobuf:"bytes,1,opt,name=pubsub_destination,json=pubsubDestination,proto3,oneof"`
}

func (*FeedOutputConfig_PubsubDestination) isFeedOutputConfig_Destination() {}

func (m *FeedOutputConfig) GetDestination() isFeedOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *FeedOutputConfig) GetPubsubDestination() *PubsubDestination {
	if x, ok := m.GetDestination().(*FeedOutputConfig_PubsubDestination); ok {
		return x.PubsubDestination
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*FeedOutputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*FeedOutputConfig_PubsubDestination)(nil),
	}
}

// An asset feed used to export asset updates to a destinations.
// An asset feed filter controls what updates are exported.
// The asset feed must be created within a project, organization, or
// folder. Supported destinations are:
// Cloud Pub/Sub topics.
type Feed struct {
	// Required. The format will be
	// projects/{project_number}/feeds/{client-assigned_feed_identifier} or
	// folders/{folder_number}/feeds/{client-assigned_feed_identifier} or
	// organizations/{organization_number}/feeds/{client-assigned_feed_identifier}
	//
	// The client-assigned feed identifier must be unique within the parent
	// project/folder/organization.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A list of the full names of the assets to receive updates. You must specify
	// either or both of asset_names and asset_types. Only asset updates matching
	// specified asset_names and asset_types are exported to the feed. For
	// example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
	// See [Resource
	// Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// for more info.
	AssetNames []string `protobuf:"bytes,2,rep,name=asset_names,json=assetNames,proto3" json:"asset_names,omitempty"`
	// A list of types of the assets to receive updates. You must specify either
	// or both of asset_names and asset_types. Only asset updates matching
	// specified asset_names and asset_types are exported to the feed.
	// For example:
	// "compute.googleapis.com/Disk" See [Introduction to Cloud Asset
	// Inventory](https://cloud.google.com/resource-manager/docs/cloud-asset-inventory/overview)
	// for all supported asset types.
	AssetTypes []string `protobuf:"bytes,3,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Asset content type. If not specified, no content but the asset name and
	// type will be returned.
	ContentType ContentType `protobuf:"varint,4,opt,name=content_type,json=contentType,proto3,enum=google.cloud.asset.v1.ContentType" json:"content_type,omitempty"`
	// Required. Feed output configuration defining where the asset updates are
	// published to.
	FeedOutputConfig     *FeedOutputConfig `protobuf:"bytes,5,opt,name=feed_output_config,json=feedOutputConfig,proto3" json:"feed_output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Feed) Reset()         { *m = Feed{} }
func (m *Feed) String() string { return proto.CompactTextString(m) }
func (*Feed) ProtoMessage()    {}
func (*Feed) Descriptor() ([]byte, []int) {
	return fileDescriptor_5104159f18b2092a, []int{15}
}

func (m *Feed) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Feed.Unmarshal(m, b)
}
func (m *Feed) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Feed.Marshal(b, m, deterministic)
}
func (m *Feed) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Feed.Merge(m, src)
}
func (m *Feed) XXX_Size() int {
	return xxx_messageInfo_Feed.Size(m)
}
func (m *Feed) XXX_DiscardUnknown() {
	xxx_messageInfo_Feed.DiscardUnknown(m)
}

var xxx_messageInfo_Feed proto.InternalMessageInfo

func (m *Feed) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Feed) GetAssetNames() []string {
	if m != nil {
		return m.AssetNames
	}
	return nil
}

func (m *Feed) GetAssetTypes() []string {
	if m != nil {
		return m.AssetTypes
	}
	return nil
}

func (m *Feed) GetContentType() ContentType {
	if m != nil {
		return m.ContentType
	}
	return ContentType_CONTENT_TYPE_UNSPECIFIED
}

func (m *Feed) GetFeedOutputConfig() *FeedOutputConfig {
	if m != nil {
		return m.FeedOutputConfig
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.asset.v1.ContentType", ContentType_name, ContentType_value)
	proto.RegisterType((*ExportAssetsRequest)(nil), "google.cloud.asset.v1.ExportAssetsRequest")
	proto.RegisterType((*ExportAssetsResponse)(nil), "google.cloud.asset.v1.ExportAssetsResponse")
	proto.RegisterType((*BatchGetAssetsHistoryRequest)(nil), "google.cloud.asset.v1.BatchGetAssetsHistoryRequest")
	proto.RegisterType((*BatchGetAssetsHistoryResponse)(nil), "google.cloud.asset.v1.BatchGetAssetsHistoryResponse")
	proto.RegisterType((*CreateFeedRequest)(nil), "google.cloud.asset.v1.CreateFeedRequest")
	proto.RegisterType((*GetFeedRequest)(nil), "google.cloud.asset.v1.GetFeedRequest")
	proto.RegisterType((*ListFeedsRequest)(nil), "google.cloud.asset.v1.ListFeedsRequest")
	proto.RegisterType((*ListFeedsResponse)(nil), "google.cloud.asset.v1.ListFeedsResponse")
	proto.RegisterType((*UpdateFeedRequest)(nil), "google.cloud.asset.v1.UpdateFeedRequest")
	proto.RegisterType((*DeleteFeedRequest)(nil), "google.cloud.asset.v1.DeleteFeedRequest")
	proto.RegisterType((*OutputConfig)(nil), "google.cloud.asset.v1.OutputConfig")
	proto.RegisterType((*GcsDestination)(nil), "google.cloud.asset.v1.GcsDestination")
	proto.RegisterType((*BigQueryDestination)(nil), "google.cloud.asset.v1.BigQueryDestination")
	proto.RegisterType((*PubsubDestination)(nil), "google.cloud.asset.v1.PubsubDestination")
	proto.RegisterType((*FeedOutputConfig)(nil), "google.cloud.asset.v1.FeedOutputConfig")
	proto.RegisterType((*Feed)(nil), "google.cloud.asset.v1.Feed")
}

func init() {
	proto.RegisterFile("google/cloud/asset/v1/asset_service.proto", fileDescriptor_5104159f18b2092a)
}

var fileDescriptor_5104159f18b2092a = []byte{
	// 1465 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x57, 0xcf, 0x6f, 0x1b, 0xc5,
	0x17, 0xcf, 0x3a, 0x49, 0x9b, 0x3c, 0xa7, 0xf9, 0xc6, 0xd3, 0xb4, 0x75, 0x9c, 0xe4, 0x1b, 0x77,
	0x4b, 0x5b, 0xc7, 0x52, 0x77, 0x95, 0xb4, 0x12, 0x52, 0x00, 0x81, 0xed, 0x3a, 0x3f, 0x50, 0x93,
	0x98, 0x4d, 0xda, 0xaa, 0x55, 0x91, 0xb5, 0xb6, 0xc7, 0x9b, 0xa5, 0xf6, 0xce, 0x76, 0x77, 0x36,
	0x69, 0x08, 0x11, 0x52, 0x85, 0xc4, 0x01, 0x71, 0x40, 0x5c, 0x40, 0x42, 0xfc, 0x01, 0x1c, 0xf9,
	0x23, 0x38, 0xf4, 0x84, 0xe0, 0xd6, 0x03, 0xea, 0x81, 0x13, 0x27, 0xce, 0x9c, 0xd0, 0xcc, 0xec,
	0x26, 0xbb, 0x6b, 0x6f, 0x9a, 0x0a, 0xc4, 0xc9, 0x3b, 0x6f, 0xde, 0x8f, 0xcf, 0x7c, 0xde, 0xcc,
	0x7b, 0xcf, 0x30, 0x6f, 0x10, 0x62, 0x74, 0xb0, 0xda, 0xec, 0x10, 0xaf, 0xa5, 0xea, 0xae, 0x8b,
	0xa9, 0xba, 0xbb, 0x20, 0x3e, 0xea, 0x2e, 0x76, 0x76, 0xcd, 0x26, 0x56, 0x6c, 0x87, 0x50, 0x82,
	0x2e, 0x08, 0x55, 0x85, 0xab, 0x2a, 0x5c, 0x43, 0xd9, 0x5d, 0xc8, 0xcd, 0xf8, 0x1e, 0x74, 0xdb,
	0x54, 0x75, 0xcb, 0x22, 0x54, 0xa7, 0x26, 0xb1, 0x5c, 0x61, 0x94, 0xbb, 0x14, 0xda, 0x6d, 0x76,
	0x4c, 0x6c, 0x51, 0x7f, 0x63, 0x2e, 0xb4, 0xd1, 0x36, 0x71, 0xa7, 0x55, 0x6f, 0xe0, 0x1d, 0x7d,
	0xd7, 0x24, 0x8e, 0xaf, 0x30, 0x15, 0x52, 0x70, 0xb0, 0x4b, 0x3c, 0x27, 0x40, 0x92, 0x93, 0x4f,
	0x00, 0x1d, 0x04, 0xbe, 0xe2, 0xeb, 0x74, 0x88, 0x65, 0x38, 0x9e, 0x65, 0x99, 0x96, 0xa1, 0x12,
	0x1b, 0x3b, 0x11, 0x74, 0xd3, 0xbe, 0x12, 0x5f, 0x35, 0xbc, 0xb6, 0x8a, 0xbb, 0x36, 0xdd, 0xf7,
	0x37, 0xf3, 0xf1, 0x4d, 0x01, 0xb3, 0xab, 0xbb, 0x8f, 0x63, 0x67, 0x38, 0xd2, 0xa0, 0x66, 0x17,
	0xbb, 0x54, 0xef, 0xda, 0x42, 0x41, 0xfe, 0x29, 0x05, 0xe7, 0xab, 0x4f, 0x6d, 0xe2, 0xd0, 0x12,
	0xc7, 0xa6, 0xe1, 0x27, 0x1e, 0x76, 0x29, 0x7a, 0x17, 0xce, 0xd8, 0xba, 0x83, 0x2d, 0x9a, 0x95,
	0xf2, 0x52, 0x61, 0xb4, 0x7c, 0xfd, 0x65, 0x29, 0xf5, 0x57, 0xe9, 0x32, 0x9a, 0xe3, 0x27, 0x12,
	0xd4, 0x0a, 0xdf, 0xba, 0x6d, 0xba, 0x4a, 0x93, 0x74, 0x55, 0xee, 0x40, 0xf3, 0xcd, 0xd0, 0x9b,
	0x30, 0xea, 0x60, 0xbd, 0x55, 0x67, 0x01, 0xb3, 0xa9, 0xbc, 0x54, 0x48, 0x2f, 0xe6, 0x7c, 0x0b,
	0x25, 0x40, 0xa3, 0x6c, 0x07, 0x68, 0xb4, 0x11, 0xa6, 0xcc, 0x96, 0x68, 0x0e, 0xd2, 0x22, 0xb7,
	0x74, 0xdf, 0xc6, 0x6e, 0x76, 0x30, 0x3f, 0x58, 0x18, 0xd5, 0x80, 0x8b, 0xb6, 0x99, 0x04, 0x55,
	0x61, 0xac, 0x49, 0x2c, 0x8a, 0x2d, 0xa1, 0x92, 0x1d, 0xca, 0x4b, 0x85, 0xf1, 0x45, 0x59, 0xe9,
	0x9b, 0x7c, 0xa5, 0x22, 0x54, 0x99, 0xa9, 0x96, 0x6e, 0x1e, 0x2f, 0xd0, 0x3a, 0x9c, 0x23, 0x1e,
	0xb5, 0x3d, 0x5a, 0x6f, 0x12, 0xab, 0x6d, 0x1a, 0xd9, 0x61, 0x0e, 0xf2, 0x4a, 0x82, 0x9f, 0x4d,
	0xae, 0x5b, 0xe1, 0xaa, 0xe5, 0xc1, 0x97, 0xa5, 0x94, 0x36, 0x46, 0x42, 0x22, 0xf9, 0x5b, 0x09,
	0x26, 0xa3, 0x44, 0xba, 0x36, 0xb1, 0x5c, 0x1c, 0x25, 0x42, 0x7a, 0x0d, 0x22, 0x56, 0xe3, 0x00,
	0x53, 0xa7, 0x06, 0x18, 0xc3, 0xf6, 0x7d, 0x0a, 0x66, 0xca, 0x3a, 0x6d, 0xee, 0xac, 0x60, 0x1f,
	0xdd, 0xaa, 0xe9, 0x52, 0xe2, 0xec, 0xff, 0x6b, 0xd9, 0x3e, 0x4a, 0x9a, 0xa5, 0x77, 0xb1, 0x9b,
	0x4d, 0x85, 0x92, 0xb6, 0xc1, 0x24, 0xe8, 0xfd, 0x58, 0xd2, 0x06, 0x4f, 0x9b, 0x34, 0xc6, 0xb5,
	0x14, 0xcd, 0x5c, 0x0d, 0x26, 0x8e, 0x18, 0xad, 0xef, 0x99, 0x56, 0x8b, 0xec, 0xf1, 0x4b, 0x90,
	0x5e, 0xbc, 0x9c, 0xe0, 0x8f, 0xf1, 0x79, 0x9f, 0x2b, 0x0a, 0x77, 0xe3, 0x01, 0xc9, 0x42, 0x28,
	0x7f, 0x08, 0xb3, 0x09, 0xfc, 0xf8, 0x49, 0x7c, 0x1b, 0xce, 0x88, 0xb7, 0x9b, 0x95, 0xf2, 0x83,
	0x85, 0xf4, 0xe2, 0x1b, 0x49, 0x81, 0x70, 0xd7, 0x26, 0x8e, 0xde, 0xf1, 0xd9, 0x11, 0x36, 0xf2,
	0x67, 0x12, 0x64, 0x2a, 0x0e, 0xd6, 0x29, 0x5e, 0xc6, 0xb8, 0x15, 0x90, 0x3e, 0x1d, 0x23, 0x9d,
	0x5f, 0xaa, 0x80, 0xd0, 0x19, 0x38, 0xdb, 0xc6, 0xb8, 0x55, 0x37, 0x5b, 0x3c, 0xed, 0xc1, 0x2e,
	0x93, 0xad, 0xb5, 0xd0, 0x2d, 0x18, 0x62, 0x5f, 0x9c, 0xc5, 0xf4, 0xe2, 0x74, 0x02, 0x18, 0x16,
	0x4c, 0xd8, 0x71, 0x6d, 0xf9, 0x0e, 0x8c, 0xaf, 0x60, 0x1a, 0x86, 0xb0, 0x04, 0x43, 0x2c, 0x61,
	0x3e, 0x80, 0x6b, 0x3c, 0xeb, 0x79, 0xf8, 0x7f, 0x72, 0xd6, 0xb9, 0x31, 0xb7, 0x91, 0x55, 0x98,
	0xb8, 0x63, 0xba, 0xdc, 0x9d, 0x7b, 0x9a, 0x23, 0xc9, 0xcb, 0x90, 0x09, 0x19, 0xf8, 0xc4, 0x2e,
	0xc0, 0x30, 0xc3, 0x16, 0xf0, 0x7a, 0xd2, 0x51, 0x34, 0xa1, 0x29, 0x7f, 0x21, 0x41, 0xe6, 0xae,
	0xdd, 0x8a, 0xb1, 0x19, 0x50, 0x22, 0xbd, 0x0e, 0x25, 0xe8, 0x3d, 0x48, 0x7b, 0xdc, 0x15, 0x2f,
	0x9a, 0x89, 0x75, 0x6a, 0x99, 0xd5, 0xd5, 0x75, 0xdd, 0x7d, 0x2c, 0x6c, 0x41, 0xd8, 0x30, 0x81,
	0xbc, 0x09, 0x99, 0xdb, 0xb8, 0x83, 0xa3, 0x60, 0xfe, 0x09, 0xaf, 0x3f, 0x4b, 0x30, 0x16, 0x7e,
	0xcb, 0xa8, 0x06, 0xff, 0x33, 0x9a, 0x6e, 0xbd, 0x85, 0x5d, 0x6a, 0x5a, 0xbc, 0x39, 0xf8, 0x87,
	0xbc, 0x9a, 0x70, 0xc8, 0x95, 0xa6, 0x7b, 0xfb, 0x58, 0x79, 0x75, 0x40, 0x1b, 0x37, 0x22, 0x12,
	0x54, 0x87, 0xc9, 0x86, 0x69, 0x3c, 0xf1, 0xb0, 0xb3, 0x1f, 0x71, 0x2b, 0x8e, 0x5f, 0x4c, 0x70,
	0x5b, 0x36, 0x8d, 0x0f, 0x98, 0x49, 0xd4, 0xf7, 0xf9, 0xc0, 0x53, 0x48, 0x5c, 0x3e, 0x07, 0xe9,
	0x90, 0x5f, 0x79, 0x0b, 0xc6, 0xa3, 0x98, 0x10, 0x82, 0x41, 0xcf, 0x31, 0x05, 0x3f, 0xab, 0x03,
	0x1a, 0x5b, 0xa0, 0x39, 0x00, 0xcf, 0x31, 0xeb, 0xb6, 0x83, 0xdb, 0xe6, 0x53, 0x71, 0xeb, 0x57,
	0x07, 0xb4, 0x51, 0xcf, 0x31, 0x6b, 0x5c, 0x54, 0x1e, 0x03, 0x20, 0x8d, 0x8f, 0x70, 0x93, 0xd6,
	0x3d, 0xc7, 0x94, 0x31, 0x9c, 0xef, 0x83, 0x08, 0xcd, 0xc2, 0xd9, 0x96, 0x4e, 0x75, 0x17, 0x47,
	0xee, 0x60, 0x20, 0x43, 0x53, 0x30, 0x4c, 0xf5, 0x46, 0x07, 0x87, 0x5f, 0x95, 0x90, 0xa0, 0x49,
	0x18, 0x6e, 0x13, 0xa7, 0x29, 0x6a, 0xd3, 0x88, 0x26, 0x16, 0xf2, 0x3c, 0x64, 0x6a, 0x5e, 0xc3,
	0xf5, 0x1a, 0xe1, 0x20, 0x93, 0x30, 0x4c, 0x89, 0x6d, 0x36, 0x45, 0x08, 0x4d, 0x2c, 0xe4, 0x4f,
	0x60, 0x82, 0xe5, 0x31, 0x92, 0xbc, 0x07, 0x80, 0x6c, 0x6e, 0xde, 0x27, 0x7f, 0x85, 0x04, 0xa2,
	0x7b, 0xe2, 0xad, 0x0e, 0x68, 0x19, 0x3b, 0x2e, 0x8c, 0x93, 0xfc, 0xcd, 0x20, 0x0c, 0xb1, 0xf0,
	0xe8, 0x52, 0xe4, 0xf2, 0x89, 0xcb, 0xce, 0x04, 0xaf, 0x2e, 0xd2, 0xff, 0x55, 0xeb, 0x7d, 0x08,
	0x88, 0x17, 0xb7, 0x7e, 0xfd, 0xf7, 0xfa, 0x09, 0x2f, 0xb7, 0xb7, 0x07, 0x4f, 0xb4, 0x63, 0xe2,
	0xa5, 0xaf, 0xa4, 0x3f, 0x4a, 0x5f, 0x4a, 0xaf, 0x7a, 0x6b, 0x68, 0xce, 0x76, 0x08, 0xbb, 0x4a,
	0xae, 0x7a, 0xe0, 0x7f, 0x1d, 0xaa, 0xbc, 0xbc, 0xa8, 0x07, 0xec, 0xe7, 0x10, 0xcd, 0xb6, 0x49,
	0xa7, 0x85, 0x1d, 0xb6, 0xe6, 0x1f, 0xb1, 0xed, 0x79, 0xe2, 0x18, 0xba, 0x65, 0x7e, 0x2c, 0x86,
	0x35, 0xf5, 0x20, 0xbc, 0x8c, 0xaa, 0xe6, 0xa5, 0x62, 0x07, 0xd2, 0x21, 0x2e, 0xd0, 0x0c, 0x64,
	0x2b, 0x9b, 0x1b, 0xdb, 0xd5, 0x8d, 0xed, 0xfa, 0xf6, 0x83, 0x5a, 0xb5, 0x7e, 0x77, 0x63, 0xab,
	0x56, 0xad, 0xac, 0x2d, 0xaf, 0x55, 0x6f, 0x4f, 0x0c, 0xa0, 0x31, 0x18, 0xd1, 0xaa, 0x5b, 0x9b,
	0x77, 0xb5, 0x4a, 0x75, 0x42, 0x42, 0xe3, 0x00, 0x6b, 0xa5, 0xf5, 0x7a, 0x6d, 0xf3, 0xce, 0x5a,
	0xe5, 0xc1, 0x44, 0x8a, 0xad, 0x37, 0xb5, 0x95, 0x60, 0x3d, 0x84, 0x32, 0x70, 0xae, 0x54, 0xa9,
	0x54, 0xb7, 0xb6, 0x02, 0xd1, 0xf0, 0xe2, 0x9f, 0x23, 0x30, 0xc6, 0xfb, 0xcf, 0x96, 0x18, 0x8e,
	0xd1, 0x6f, 0x12, 0x8c, 0x85, 0x47, 0x13, 0x94, 0xf4, 0xc2, 0xfb, 0x0c, 0x82, 0xb9, 0xd9, 0x40,
	0x37, 0x34, 0xa6, 0x2a, 0x9b, 0xc1, 0x98, 0x2a, 0x3f, 0x93, 0x9e, 0x97, 0xee, 0x43, 0xf1, 0x34,
	0xfe, 0xfc, 0x8a, 0x3f, 0x7f, 0xea, 0xd8, 0xcf, 0x7e, 0xfd, 0xfd, 0xeb, 0x94, 0x2c, 0xcf, 0xb2,
	0xc9, 0xf9, 0x40, 0x34, 0x91, 0x77, 0x8a, 0x6a, 0xf1, 0x70, 0x09, 0x87, 0x74, 0x97, 0xa4, 0x22,
	0xfa, 0x51, 0x82, 0x0b, 0x7d, 0xfb, 0x37, 0xba, 0x99, 0x54, 0xcb, 0x4e, 0x98, 0x86, 0x72, 0xb7,
	0x5e, 0xcf, 0x48, 0x9c, 0x4b, 0x56, 0x38, 0xdc, 0x02, 0xba, 0xd6, 0x03, 0xb7, 0xd1, 0x17, 0xda,
	0xa7, 0x00, 0xc7, 0x33, 0x01, 0x4a, 0xaa, 0x05, 0x3d, 0x63, 0x43, 0xee, 0xa4, 0xd6, 0x26, 0x17,
	0x5f, 0x94, 0xfc, 0x76, 0xcb, 0xd1, 0x4c, 0xcb, 0x17, 0xe3, 0x68, 0xc4, 0xdd, 0x64, 0xac, 0x51,
	0x38, 0xeb, 0x8f, 0x03, 0x28, 0xb1, 0x93, 0x44, 0xc6, 0x85, 0x93, 0x43, 0x5f, 0x7d, 0x51, 0xe2,
	0x65, 0x86, 0x07, 0xce, 0x22, 0x11, 0x98, 0x09, 0x58, 0x58, 0xff, 0x45, 0x14, 0x0f, 0xd1, 0xe7,
	0x12, 0x8c, 0x1e, 0x8d, 0x01, 0x28, 0xe9, 0xb5, 0xc7, 0x27, 0x8b, 0x5c, 0xe1, 0xd5, 0x8a, 0x7e,
	0x1e, 0xae, 0x47, 0x29, 0x08, 0x90, 0xf4, 0x50, 0x80, 0x9e, 0x49, 0x00, 0xc7, 0x73, 0x44, 0x62,
	0x06, 0x7a, 0x46, 0x8d, 0x93, 0x69, 0xb8, 0xf1, 0xa2, 0xc4, 0x47, 0x0b, 0x1e, 0x3c, 0xbf, 0x38,
	0xcd, 0x83, 0x33, 0x81, 0xd2, 0xc3, 0x05, 0x4b, 0x82, 0x07, 0x70, 0x3c, 0x3e, 0x24, 0x62, 0xe8,
	0x99, 0x30, 0x72, 0x17, 0x7b, 0x66, 0x94, 0x2a, 0xfb, 0x63, 0x18, 0xcb, 0x42, 0x31, 0x21, 0x0b,
	0xb9, 0xf5, 0xe7, 0xa5, 0xa9, 0xc4, 0x0a, 0xf9, 0x4b, 0x49, 0xd9, 0xa1, 0xd4, 0x76, 0x97, 0x54,
	0x75, 0x6f, 0x6f, 0x2f, 0x5e, 0x3e, 0x75, 0x8f, 0xee, 0x88, 0xff, 0xb5, 0x37, 0xec, 0x8e, 0x4e,
	0xdb, 0xc4, 0xe9, 0x96, 0xbf, 0x93, 0x60, 0xaa, 0x49, 0xba, 0xfd, 0xd1, 0x97, 0x33, 0xe1, 0x6a,
	0x54, 0x63, 0x78, 0x6b, 0xd2, 0xc3, 0x25, 0x5f, 0xd7, 0x20, 0x1d, 0xdd, 0x32, 0x14, 0xe2, 0x18,
	0xaa, 0x81, 0x2d, 0x7e, 0x1a, 0xf5, 0x38, 0x62, 0xec, 0x0f, 0xf4, 0x5b, 0xfc, 0xe3, 0x87, 0xd4,
	0x85, 0x15, 0x61, 0x5c, 0xe1, 0x81, 0xb8, 0x7b, 0xe5, 0xde, 0xc2, 0xf3, 0x40, 0xfe, 0x88, 0xcb,
	0x1f, 0x71, 0xf9, 0xa3, 0x7b, 0x0b, 0x8d, 0x33, 0xdc, 0xed, 0xcd, 0xbf, 0x03, 0x00, 0x00, 0xff,
	0xff, 0xaa, 0x4b, 0x9d, 0x11, 0x4b, 0x10, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AssetServiceClient is the client API for AssetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AssetServiceClient interface {
	// Exports assets with time and resource types to a given Cloud Storage
	// location. The output format is newline-delimited JSON.
	// This API implements the [google.longrunning.Operation][google.longrunning.Operation] API allowing you
	// to keep track of the export.
	ExportAssets(ctx context.Context, in *ExportAssetsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Batch gets the update history of assets that overlap a time window.
	// For RESOURCE content, this API outputs history with asset in both
	// non-delete or deleted status.
	// For IAM_POLICY content, this API outputs history when the asset and its
	// attached IAM POLICY both exist. This can create gaps in the output history.
	// If a specified asset does not exist, this API returns an INVALID_ARGUMENT
	// error.
	BatchGetAssetsHistory(ctx context.Context, in *BatchGetAssetsHistoryRequest, opts ...grpc.CallOption) (*BatchGetAssetsHistoryResponse, error)
	// Creates a feed in a parent project/folder/organization to listen to its
	// asset updates.
	CreateFeed(ctx context.Context, in *CreateFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Gets details about an asset feed.
	GetFeed(ctx context.Context, in *GetFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Lists all asset feeds in a parent project/folder/organization.
	ListFeeds(ctx context.Context, in *ListFeedsRequest, opts ...grpc.CallOption) (*ListFeedsResponse, error)
	// Updates an asset feed configuration.
	UpdateFeed(ctx context.Context, in *UpdateFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Deletes an asset feed.
	DeleteFeed(ctx context.Context, in *DeleteFeedRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type assetServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAssetServiceClient(cc grpc.ClientConnInterface) AssetServiceClient {
	return &assetServiceClient{cc}
}

func (c *assetServiceClient) ExportAssets(ctx context.Context, in *ExportAssetsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/ExportAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) BatchGetAssetsHistory(ctx context.Context, in *BatchGetAssetsHistoryRequest, opts ...grpc.CallOption) (*BatchGetAssetsHistoryResponse, error) {
	out := new(BatchGetAssetsHistoryResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/BatchGetAssetsHistory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) CreateFeed(ctx context.Context, in *CreateFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/CreateFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) GetFeed(ctx context.Context, in *GetFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/GetFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) ListFeeds(ctx context.Context, in *ListFeedsRequest, opts ...grpc.CallOption) (*ListFeedsResponse, error) {
	out := new(ListFeedsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/ListFeeds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) UpdateFeed(ctx context.Context, in *UpdateFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/UpdateFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) DeleteFeed(ctx context.Context, in *DeleteFeedRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/DeleteFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AssetServiceServer is the server API for AssetService service.
type AssetServiceServer interface {
	// Exports assets with time and resource types to a given Cloud Storage
	// location. The output format is newline-delimited JSON.
	// This API implements the [google.longrunning.Operation][google.longrunning.Operation] API allowing you
	// to keep track of the export.
	ExportAssets(context.Context, *ExportAssetsRequest) (*longrunning.Operation, error)
	// Batch gets the update history of assets that overlap a time window.
	// For RESOURCE content, this API outputs history with asset in both
	// non-delete or deleted status.
	// For IAM_POLICY content, this API outputs history when the asset and its
	// attached IAM POLICY both exist. This can create gaps in the output history.
	// If a specified asset does not exist, this API returns an INVALID_ARGUMENT
	// error.
	BatchGetAssetsHistory(context.Context, *BatchGetAssetsHistoryRequest) (*BatchGetAssetsHistoryResponse, error)
	// Creates a feed in a parent project/folder/organization to listen to its
	// asset updates.
	CreateFeed(context.Context, *CreateFeedRequest) (*Feed, error)
	// Gets details about an asset feed.
	GetFeed(context.Context, *GetFeedRequest) (*Feed, error)
	// Lists all asset feeds in a parent project/folder/organization.
	ListFeeds(context.Context, *ListFeedsRequest) (*ListFeedsResponse, error)
	// Updates an asset feed configuration.
	UpdateFeed(context.Context, *UpdateFeedRequest) (*Feed, error)
	// Deletes an asset feed.
	DeleteFeed(context.Context, *DeleteFeedRequest) (*empty.Empty, error)
}

// UnimplementedAssetServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAssetServiceServer struct {
}

func (*UnimplementedAssetServiceServer) ExportAssets(ctx context.Context, req *ExportAssetsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportAssets not implemented")
}
func (*UnimplementedAssetServiceServer) BatchGetAssetsHistory(ctx context.Context, req *BatchGetAssetsHistoryRequest) (*BatchGetAssetsHistoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchGetAssetsHistory not implemented")
}
func (*UnimplementedAssetServiceServer) CreateFeed(ctx context.Context, req *CreateFeedRequest) (*Feed, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFeed not implemented")
}
func (*UnimplementedAssetServiceServer) GetFeed(ctx context.Context, req *GetFeedRequest) (*Feed, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFeed not implemented")
}
func (*UnimplementedAssetServiceServer) ListFeeds(ctx context.Context, req *ListFeedsRequest) (*ListFeedsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFeeds not implemented")
}
func (*UnimplementedAssetServiceServer) UpdateFeed(ctx context.Context, req *UpdateFeedRequest) (*Feed, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFeed not implemented")
}
func (*UnimplementedAssetServiceServer) DeleteFeed(ctx context.Context, req *DeleteFeedRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFeed not implemented")
}

func RegisterAssetServiceServer(s *grpc.Server, srv AssetServiceServer) {
	s.RegisterService(&_AssetService_serviceDesc, srv)
}

func _AssetService_ExportAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ExportAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/ExportAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ExportAssets(ctx, req.(*ExportAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_BatchGetAssetsHistory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetAssetsHistoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).BatchGetAssetsHistory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/BatchGetAssetsHistory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).BatchGetAssetsHistory(ctx, req.(*BatchGetAssetsHistoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_CreateFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).CreateFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/CreateFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).CreateFeed(ctx, req.(*CreateFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_GetFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).GetFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/GetFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).GetFeed(ctx, req.(*GetFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_ListFeeds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFeedsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ListFeeds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/ListFeeds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ListFeeds(ctx, req.(*ListFeedsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_UpdateFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).UpdateFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/UpdateFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).UpdateFeed(ctx, req.(*UpdateFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_DeleteFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).DeleteFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/DeleteFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).DeleteFeed(ctx, req.(*DeleteFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AssetService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.asset.v1.AssetService",
	HandlerType: (*AssetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ExportAssets",
			Handler:    _AssetService_ExportAssets_Handler,
		},
		{
			MethodName: "BatchGetAssetsHistory",
			Handler:    _AssetService_BatchGetAssetsHistory_Handler,
		},
		{
			MethodName: "CreateFeed",
			Handler:    _AssetService_CreateFeed_Handler,
		},
		{
			MethodName: "GetFeed",
			Handler:    _AssetService_GetFeed_Handler,
		},
		{
			MethodName: "ListFeeds",
			Handler:    _AssetService_ListFeeds_Handler,
		},
		{
			MethodName: "UpdateFeed",
			Handler:    _AssetService_UpdateFeed_Handler,
		},
		{
			MethodName: "DeleteFeed",
			Handler:    _AssetService_DeleteFeed_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/asset/v1/asset_service.proto",
}
