// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/hive/pkg/apis/hive/v1"
	scheme "github.com/openshift/hive/pkg/client/clientset-generated/clientset/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CheckpointsGetter has a method to return a CheckpointInterface.
// A group's client should implement this interface.
type CheckpointsGetter interface {
	Checkpoints(namespace string) CheckpointInterface
}

// CheckpointInterface has methods to work with Checkpoint resources.
type CheckpointInterface interface {
	Create(*v1.Checkpoint) (*v1.Checkpoint, error)
	Update(*v1.Checkpoint) (*v1.Checkpoint, error)
	UpdateStatus(*v1.Checkpoint) (*v1.Checkpoint, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.Checkpoint, error)
	List(opts metav1.ListOptions) (*v1.CheckpointList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.Checkpoint, err error)
	CheckpointExpansion
}

// checkpoints implements CheckpointInterface
type checkpoints struct {
	client rest.Interface
	ns     string
}

// newCheckpoints returns a Checkpoints
func newCheckpoints(c *HiveV1Client, namespace string) *checkpoints {
	return &checkpoints{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the checkpoint, and returns the corresponding checkpoint object, and an error if there is any.
func (c *checkpoints) Get(name string, options metav1.GetOptions) (result *v1.Checkpoint, err error) {
	result = &v1.Checkpoint{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("checkpoints").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Checkpoints that match those selectors.
func (c *checkpoints) List(opts metav1.ListOptions) (result *v1.CheckpointList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.CheckpointList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("checkpoints").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested checkpoints.
func (c *checkpoints) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("checkpoints").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a checkpoint and creates it.  Returns the server's representation of the checkpoint, and an error, if there is any.
func (c *checkpoints) Create(checkpoint *v1.Checkpoint) (result *v1.Checkpoint, err error) {
	result = &v1.Checkpoint{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("checkpoints").
		Body(checkpoint).
		Do().
		Into(result)
	return
}

// Update takes the representation of a checkpoint and updates it. Returns the server's representation of the checkpoint, and an error, if there is any.
func (c *checkpoints) Update(checkpoint *v1.Checkpoint) (result *v1.Checkpoint, err error) {
	result = &v1.Checkpoint{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("checkpoints").
		Name(checkpoint.Name).
		Body(checkpoint).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *checkpoints) UpdateStatus(checkpoint *v1.Checkpoint) (result *v1.Checkpoint, err error) {
	result = &v1.Checkpoint{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("checkpoints").
		Name(checkpoint.Name).
		SubResource("status").
		Body(checkpoint).
		Do().
		Into(result)
	return
}

// Delete takes name of the checkpoint and deletes it. Returns an error if one occurs.
func (c *checkpoints) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("checkpoints").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *checkpoints) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("checkpoints").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched checkpoint.
func (c *checkpoints) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.Checkpoint, err error) {
	result = &v1.Checkpoint{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("checkpoints").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
