package tests

import (
	"fmt"
	"testing"

	"github.com/hashicorp/terraform-plugin-sdk/helper/resource"
	"github.com/terraform-providers/terraform-provider-azurerm/azurerm/internal/acceptance"
)

func TestAccDataSourceAzureRMKeyVaultSecret_basic(t *testing.T) {
	data := acceptance.BuildTestData(t, "data.azurerm_key_vault_secret", "test")

	resource.ParallelTest(t, resource.TestCase{
		PreCheck:  func() { acceptance.PreCheck(t) },
		Providers: acceptance.SupportedProviders,
		Steps: []resource.TestStep{
			{
				Config: testAccDataSourceKeyVaultSecret_basic(data),
				Check: resource.ComposeTestCheckFunc(
					resource.TestCheckResourceAttr(data.ResourceName, "value", "rick-and-morty"),
					resource.TestCheckResourceAttr(data.ResourceName, "tags.%", "0"),
				),
			},
		},
	})
}

func TestAccDataSourceAzureRMKeyVaultSecret_complete(t *testing.T) {
	data := acceptance.BuildTestData(t, "data.azurerm_key_vault_secret", "test")

	resource.ParallelTest(t, resource.TestCase{
		PreCheck:  func() { acceptance.PreCheck(t) },
		Providers: acceptance.SupportedProviders,
		Steps: []resource.TestStep{
			{
				Config: testAccDataSourceKeyVaultSecret_complete(data),
				Check: resource.ComposeTestCheckFunc(
					resource.TestCheckResourceAttr(data.ResourceName, "value", "<rick><morty /></rick>"),
					resource.TestCheckResourceAttr(data.ResourceName, "tags.%", "1"),
					resource.TestCheckResourceAttr(data.ResourceName, "tags.hello", "world"),
				),
			},
		},
	})
}

func testAccDataSourceKeyVaultSecret_basic(data acceptance.TestData) string {
	r := testAccAzureRMKeyVaultSecret_basic(data)
	return fmt.Sprintf(`
%s

data "azurerm_key_vault_secret" "test" {
  name         = "${azurerm_key_vault_secret.test.name}"
  key_vault_id = "${azurerm_key_vault.test.id}"
}
`, r)
}

func testAccDataSourceKeyVaultSecret_complete(data acceptance.TestData) string {
	r := testAccAzureRMKeyVaultSecret_complete(data)
	return fmt.Sprintf(`
%s

data "azurerm_key_vault_secret" "test" {
  name         = "${azurerm_key_vault_secret.test.name}"
  key_vault_id = "${azurerm_key_vault.test.id}"
}
`, r)
}
