---
layout: guides
sidebar_current: guides-packer-on-cicd-upload-image-to-artifact-store
page_title: Upload VirtualBox Image to S3
---

# Upload VirtualBox Image to S3

Once the image is generated it will be used by other parts of your operations
workflow. For example, it is common to build VirtualBox images with Packer to
be used as base boxes in Vagrant.

The exact process for uploading images depends on the artifact store and CI
system you use. TeamCity provides a [Build
Artifacts](https://confluence.jetbrains.com/display/TCD9/Build+Artifact)
feature which can be used to store the newly generated image. Other CI/CD
services also have similar build artifacts features built in, like [Circle CI
Build Artifacts](https://circleci.com/docs/2.0/artifacts/). In addition to the
built in artifact stores in CI/CD tools, there are also dedicated universal
artifact storage services like
[Artifactory](https://confluence.jetbrains.com/display/TCD9/Build+Artifact).
All of these are great options for image artifact storage.

The following example uses TeamCity and Amazon S3.

## Example: Uploading to S3 in a TeamCity Build

On the agent machine responsible for building images, install the [AWS Command
Line Tool](https://aws.amazon.com/cli/). Since this is a one-time operation,
this can be incorporated into the initial agent provisioning step when
installing other dependencies. The AWS Command Line tool may require installing
additional
[dependencies](http://docs.aws.amazon.com/cli/latest/userguide/installing.html)
prior.

```shell
pip install awscli
```

In your build configuration in TeamCity Server, add an additional **Build Step:
Command Line** and set the **Script content** field to the following:

```shell
awscli s3 cp . s3://bucket/ --exclude “*” --include “*.ovf"
```
