package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDataSetMessage invokes the airec.DescribeDataSetMessage API synchronously
// api document: https://help.aliyun.com/api/airec/describedatasetmessage.html
func (client *Client) DescribeDataSetMessage(request *DescribeDataSetMessageRequest) (response *DescribeDataSetMessageResponse, err error) {
	response = CreateDescribeDataSetMessageResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDataSetMessageWithChan invokes the airec.DescribeDataSetMessage API asynchronously
// api document: https://help.aliyun.com/api/airec/describedatasetmessage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDataSetMessageWithChan(request *DescribeDataSetMessageRequest) (<-chan *DescribeDataSetMessageResponse, <-chan error) {
	responseChan := make(chan *DescribeDataSetMessageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDataSetMessage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDataSetMessageWithCallback invokes the airec.DescribeDataSetMessage API asynchronously
// api document: https://help.aliyun.com/api/airec/describedatasetmessage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDataSetMessageWithCallback(request *DescribeDataSetMessageRequest, callback func(response *DescribeDataSetMessageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDataSetMessageResponse
		var err error
		defer close(result)
		response, err = client.DescribeDataSetMessage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDataSetMessageRequest is the request struct for api DescribeDataSetMessage
type DescribeDataSetMessageRequest struct {
	*requests.RoaRequest
	VersionId  string `position:"Path" name:"VersionId"`
	InstanceId string `position:"Path" name:"InstanceId"`
}

// DescribeDataSetMessageResponse is the response struct for api DescribeDataSetMessage
type DescribeDataSetMessageResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Code      string       `json:"Code" xml:"Code"`
	Message   string       `json:"Message" xml:"Message"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateDescribeDataSetMessageRequest creates a request to invoke DescribeDataSetMessage API
func CreateDescribeDataSetMessageRequest() (request *DescribeDataSetMessageRequest) {
	request = &DescribeDataSetMessageRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2018-10-12", "DescribeDataSetMessage", "/openapi/instances/[InstanceId]/dataSets/[VersionId]/messages", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeDataSetMessageResponse creates a response to parse from DescribeDataSetMessage response
func CreateDescribeDataSetMessageResponse() (response *DescribeDataSetMessageResponse) {
	response = &DescribeDataSetMessageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
