package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRetcodeApps invokes the arms.ListRetcodeApps API synchronously
// api document: https://help.aliyun.com/api/arms/listretcodeapps.html
func (client *Client) ListRetcodeApps(request *ListRetcodeAppsRequest) (response *ListRetcodeAppsResponse, err error) {
	response = CreateListRetcodeAppsResponse()
	err = client.DoAction(request, response)
	return
}

// ListRetcodeAppsWithChan invokes the arms.ListRetcodeApps API asynchronously
// api document: https://help.aliyun.com/api/arms/listretcodeapps.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRetcodeAppsWithChan(request *ListRetcodeAppsRequest) (<-chan *ListRetcodeAppsResponse, <-chan error) {
	responseChan := make(chan *ListRetcodeAppsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRetcodeApps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRetcodeAppsWithCallback invokes the arms.ListRetcodeApps API asynchronously
// api document: https://help.aliyun.com/api/arms/listretcodeapps.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRetcodeAppsWithCallback(request *ListRetcodeAppsRequest, callback func(response *ListRetcodeAppsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRetcodeAppsResponse
		var err error
		defer close(result)
		response, err = client.ListRetcodeApps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRetcodeAppsRequest is the request struct for api ListRetcodeApps
type ListRetcodeAppsRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// ListRetcodeAppsResponse is the response struct for api ListRetcodeApps
type ListRetcodeAppsResponse struct {
	*responses.BaseResponse
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	RetcodeApps []RetcodeApp `json:"RetcodeApps" xml:"RetcodeApps"`
}

// CreateListRetcodeAppsRequest creates a request to invoke ListRetcodeApps API
func CreateListRetcodeAppsRequest() (request *ListRetcodeAppsRequest) {
	request = &ListRetcodeAppsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "ListRetcodeApps", "arms", "openAPI")
	return
}

// CreateListRetcodeAppsResponse creates a response to parse from ListRetcodeApps response
func CreateListRetcodeAppsResponse() (response *ListRetcodeAppsResponse) {
	response = &ListRetcodeAppsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
