package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCdnTypes invokes the cdn.DescribeCdnTypes API synchronously
// api document: https://help.aliyun.com/api/cdn/describecdntypes.html
func (client *Client) DescribeCdnTypes(request *DescribeCdnTypesRequest) (response *DescribeCdnTypesResponse, err error) {
	response = CreateDescribeCdnTypesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCdnTypesWithChan invokes the cdn.DescribeCdnTypes API asynchronously
// api document: https://help.aliyun.com/api/cdn/describecdntypes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCdnTypesWithChan(request *DescribeCdnTypesRequest) (<-chan *DescribeCdnTypesResponse, <-chan error) {
	responseChan := make(chan *DescribeCdnTypesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCdnTypes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCdnTypesWithCallback invokes the cdn.DescribeCdnTypes API asynchronously
// api document: https://help.aliyun.com/api/cdn/describecdntypes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCdnTypesWithCallback(request *DescribeCdnTypesRequest, callback func(response *DescribeCdnTypesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCdnTypesResponse
		var err error
		defer close(result)
		response, err = client.DescribeCdnTypes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCdnTypesRequest is the request struct for api DescribeCdnTypes
type DescribeCdnTypesRequest struct {
	*requests.RpcRequest
	OwnerAccount  string           `position:"Query" name:"OwnerAccount"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// DescribeCdnTypesResponse is the response struct for api DescribeCdnTypes
type DescribeCdnTypesResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	CdnTypes  CdnTypes `json:"CdnTypes" xml:"CdnTypes"`
}

// CreateDescribeCdnTypesRequest creates a request to invoke DescribeCdnTypes API
func CreateDescribeCdnTypesRequest() (request *DescribeCdnTypesRequest) {
	request = &DescribeCdnTypesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2014-11-11", "DescribeCdnTypes", "", "")
	return
}

// CreateDescribeCdnTypesResponse creates a response to parse from DescribeCdnTypes response
func CreateDescribeCdnTypesResponse() (response *DescribeCdnTypesResponse) {
	response = &DescribeCdnTypesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
