package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUserCustomerLabels invokes the cdn.DescribeUserCustomerLabels API synchronously
// api document: https://help.aliyun.com/api/cdn/describeusercustomerlabels.html
func (client *Client) DescribeUserCustomerLabels(request *DescribeUserCustomerLabelsRequest) (response *DescribeUserCustomerLabelsResponse, err error) {
	response = CreateDescribeUserCustomerLabelsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserCustomerLabelsWithChan invokes the cdn.DescribeUserCustomerLabels API asynchronously
// api document: https://help.aliyun.com/api/cdn/describeusercustomerlabels.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeUserCustomerLabelsWithChan(request *DescribeUserCustomerLabelsRequest) (<-chan *DescribeUserCustomerLabelsResponse, <-chan error) {
	responseChan := make(chan *DescribeUserCustomerLabelsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUserCustomerLabels(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserCustomerLabelsWithCallback invokes the cdn.DescribeUserCustomerLabels API asynchronously
// api document: https://help.aliyun.com/api/cdn/describeusercustomerlabels.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeUserCustomerLabelsWithCallback(request *DescribeUserCustomerLabelsRequest, callback func(response *DescribeUserCustomerLabelsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserCustomerLabelsResponse
		var err error
		defer close(result)
		response, err = client.DescribeUserCustomerLabels(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserCustomerLabelsRequest is the request struct for api DescribeUserCustomerLabels
type DescribeUserCustomerLabelsRequest struct {
	*requests.RpcRequest
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	Uid           requests.Integer `position:"Query" name:"Uid"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// DescribeUserCustomerLabelsResponse is the response struct for api DescribeUserCustomerLabels
type DescribeUserCustomerLabelsResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	IsInnerUser bool   `json:"IsInnerUser" xml:"IsInnerUser"`
}

// CreateDescribeUserCustomerLabelsRequest creates a request to invoke DescribeUserCustomerLabels API
func CreateDescribeUserCustomerLabelsRequest() (request *DescribeUserCustomerLabelsRequest) {
	request = &DescribeUserCustomerLabelsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2014-11-11", "DescribeUserCustomerLabels", "", "")
	return
}

// CreateDescribeUserCustomerLabelsResponse creates a response to parse from DescribeUserCustomerLabels response
func CreateDescribeUserCustomerLabelsResponse() (response *DescribeUserCustomerLabelsResponse) {
	response = &DescribeUserCustomerLabelsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
