package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateFCTrigger invokes the cdn.UpdateFCTrigger API synchronously
// api document: https://help.aliyun.com/api/cdn/updatefctrigger.html
func (client *Client) UpdateFCTrigger(request *UpdateFCTriggerRequest) (response *UpdateFCTriggerResponse, err error) {
	response = CreateUpdateFCTriggerResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateFCTriggerWithChan invokes the cdn.UpdateFCTrigger API asynchronously
// api document: https://help.aliyun.com/api/cdn/updatefctrigger.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateFCTriggerWithChan(request *UpdateFCTriggerRequest) (<-chan *UpdateFCTriggerResponse, <-chan error) {
	responseChan := make(chan *UpdateFCTriggerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateFCTrigger(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateFCTriggerWithCallback invokes the cdn.UpdateFCTrigger API asynchronously
// api document: https://help.aliyun.com/api/cdn/updatefctrigger.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateFCTriggerWithCallback(request *UpdateFCTriggerRequest, callback func(response *UpdateFCTriggerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateFCTriggerResponse
		var err error
		defer close(result)
		response, err = client.UpdateFCTrigger(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateFCTriggerRequest is the request struct for api UpdateFCTrigger
type UpdateFCTriggerRequest struct {
	*requests.RpcRequest
	Notes       string           `position:"Body" name:"Notes"`
	TriggerARN  string           `position:"Query" name:"TriggerARN"`
	SourceARN   string           `position:"Body" name:"SourceARN"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	RoleARN     string           `position:"Body" name:"RoleARN"`
	FunctionARN string           `position:"Body" name:"FunctionARN"`
}

// UpdateFCTriggerResponse is the response struct for api UpdateFCTrigger
type UpdateFCTriggerResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateFCTriggerRequest creates a request to invoke UpdateFCTrigger API
func CreateUpdateFCTriggerRequest() (request *UpdateFCTriggerRequest) {
	request = &UpdateFCTriggerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "UpdateFCTrigger", "", "")
	return
}

// CreateUpdateFCTriggerResponse creates a response to parse from UpdateFCTrigger response
func CreateUpdateFCTriggerResponse() (response *UpdateFCTriggerResponse) {
	response = &UpdateFCTriggerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
