package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEslDevices invokes the cloudesl.DescribeEslDevices API synchronously
// api document: https://help.aliyun.com/api/cloudesl/describeesldevices.html
func (client *Client) DescribeEslDevices(request *DescribeEslDevicesRequest) (response *DescribeEslDevicesResponse, err error) {
	response = CreateDescribeEslDevicesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEslDevicesWithChan invokes the cloudesl.DescribeEslDevices API asynchronously
// api document: https://help.aliyun.com/api/cloudesl/describeesldevices.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEslDevicesWithChan(request *DescribeEslDevicesRequest) (<-chan *DescribeEslDevicesResponse, <-chan error) {
	responseChan := make(chan *DescribeEslDevicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEslDevices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEslDevicesWithCallback invokes the cloudesl.DescribeEslDevices API asynchronously
// api document: https://help.aliyun.com/api/cloudesl/describeesldevices.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEslDevicesWithCallback(request *DescribeEslDevicesRequest, callback func(response *DescribeEslDevicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEslDevicesResponse
		var err error
		defer close(result)
		response, err = client.DescribeEslDevices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEslDevicesRequest is the request struct for api DescribeEslDevices
type DescribeEslDevicesRequest struct {
	*requests.RpcRequest
	EslStatus        string           `position:"Query" name:"EslStatus"`
	ToBatteryLevel   requests.Integer `position:"Query" name:"ToBatteryLevel"`
	StoreId          string           `position:"Query" name:"StoreId"`
	Type             string           `position:"Query" name:"Type"`
	Mac              string           `position:"Query" name:"Mac"`
	PageNumber       requests.Integer `position:"Query" name:"PageNumber"`
	FromBatteryLevel requests.Integer `position:"Query" name:"FromBatteryLevel"`
	ShelfCode        string           `position:"Query" name:"ShelfCode"`
	EslBarCode       string           `position:"Query" name:"EslBarCode"`
	Vendor           string           `position:"Query" name:"Vendor"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	BeBind           requests.Boolean `position:"Query" name:"BeBind"`
	ItemBarCode      string           `position:"Query" name:"ItemBarCode"`
}

// DescribeEslDevicesResponse is the response struct for api DescribeEslDevices
type DescribeEslDevicesResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Success    bool       `json:"Success" xml:"Success"`
	Message    string     `json:"Message" xml:"Message"`
	ErrorCode  string     `json:"ErrorCode" xml:"ErrorCode"`
	TotalCount int        `json:"TotalCount" xml:"TotalCount"`
	PageNumber int        `json:"PageNumber" xml:"PageNumber"`
	PageSize   int        `json:"PageSize" xml:"PageSize"`
	EslDevices EslDevices `json:"EslDevices" xml:"EslDevices"`
}

// CreateDescribeEslDevicesRequest creates a request to invoke DescribeEslDevices API
func CreateDescribeEslDevicesRequest() (request *DescribeEslDevicesRequest) {
	request = &DescribeEslDevicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2018-08-01", "DescribeEslDevices", "", "")
	return
}

// CreateDescribeEslDevicesResponse creates a response to parse from DescribeEslDevices response
func CreateDescribeEslDevicesResponse() (response *DescribeEslDevicesResponse) {
	response = &DescribeEslDevicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
