package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetApPortalBind invokes the cloudwf.GetApPortalBind API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getapportalbind.html
func (client *Client) GetApPortalBind(request *GetApPortalBindRequest) (response *GetApPortalBindResponse, err error) {
	response = CreateGetApPortalBindResponse()
	err = client.DoAction(request, response)
	return
}

// GetApPortalBindWithChan invokes the cloudwf.GetApPortalBind API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getapportalbind.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetApPortalBindWithChan(request *GetApPortalBindRequest) (<-chan *GetApPortalBindResponse, <-chan error) {
	responseChan := make(chan *GetApPortalBindResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetApPortalBind(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetApPortalBindWithCallback invokes the cloudwf.GetApPortalBind API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getapportalbind.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetApPortalBindWithCallback(request *GetApPortalBindRequest, callback func(response *GetApPortalBindResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetApPortalBindResponse
		var err error
		defer close(result)
		response, err = client.GetApPortalBind(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetApPortalBindRequest is the request struct for api GetApPortalBind
type GetApPortalBindRequest struct {
	*requests.RpcRequest
	ConfigType requests.Integer `position:"Query" name:"ConfigType"`
	BindId     requests.Integer `position:"Query" name:"BindId"`
}

// GetApPortalBindResponse is the response struct for api GetApPortalBind
type GetApPortalBindResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetApPortalBindRequest creates a request to invoke GetApPortalBind API
func CreateGetApPortalBindRequest() (request *GetApPortalBindRequest) {
	request = &GetApPortalBindRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetApPortalBind", "cloudwf", "openAPI")
	return
}

// CreateGetApPortalBindResponse creates a response to parse from GetApPortalBind response
func CreateGetApPortalBindResponse() (response *GetApPortalBindResponse) {
	response = &GetApPortalBindResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
