package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateInstanceVpcEndpointLinkedVpc invokes the cr.CreateInstanceVpcEndpointLinkedVpc API synchronously
// api document: https://help.aliyun.com/api/cr/createinstancevpcendpointlinkedvpc.html
func (client *Client) CreateInstanceVpcEndpointLinkedVpc(request *CreateInstanceVpcEndpointLinkedVpcRequest) (response *CreateInstanceVpcEndpointLinkedVpcResponse, err error) {
	response = CreateCreateInstanceVpcEndpointLinkedVpcResponse()
	err = client.DoAction(request, response)
	return
}

// CreateInstanceVpcEndpointLinkedVpcWithChan invokes the cr.CreateInstanceVpcEndpointLinkedVpc API asynchronously
// api document: https://help.aliyun.com/api/cr/createinstancevpcendpointlinkedvpc.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateInstanceVpcEndpointLinkedVpcWithChan(request *CreateInstanceVpcEndpointLinkedVpcRequest) (<-chan *CreateInstanceVpcEndpointLinkedVpcResponse, <-chan error) {
	responseChan := make(chan *CreateInstanceVpcEndpointLinkedVpcResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateInstanceVpcEndpointLinkedVpc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateInstanceVpcEndpointLinkedVpcWithCallback invokes the cr.CreateInstanceVpcEndpointLinkedVpc API asynchronously
// api document: https://help.aliyun.com/api/cr/createinstancevpcendpointlinkedvpc.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateInstanceVpcEndpointLinkedVpcWithCallback(request *CreateInstanceVpcEndpointLinkedVpcRequest, callback func(response *CreateInstanceVpcEndpointLinkedVpcResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateInstanceVpcEndpointLinkedVpcResponse
		var err error
		defer close(result)
		response, err = client.CreateInstanceVpcEndpointLinkedVpc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateInstanceVpcEndpointLinkedVpcRequest is the request struct for api CreateInstanceVpcEndpointLinkedVpc
type CreateInstanceVpcEndpointLinkedVpcRequest struct {
	*requests.RpcRequest
	VswitchId  string `position:"Query" name:"VswitchId"`
	InstanceId string `position:"Query" name:"InstanceId"`
	VpcId      string `position:"Query" name:"VpcId"`
	ModuleName string `position:"Query" name:"ModuleName"`
}

// CreateInstanceVpcEndpointLinkedVpcResponse is the response struct for api CreateInstanceVpcEndpointLinkedVpc
type CreateInstanceVpcEndpointLinkedVpcResponse struct {
	*responses.BaseResponse
	CreateInstanceVpcEndpointLinkedVpcIsSuccess bool   `json:"IsSuccess" xml:"IsSuccess"`
	Code                                        string `json:"Code" xml:"Code"`
	RequestId                                   string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateInstanceVpcEndpointLinkedVpcRequest creates a request to invoke CreateInstanceVpcEndpointLinkedVpc API
func CreateCreateInstanceVpcEndpointLinkedVpcRequest() (request *CreateInstanceVpcEndpointLinkedVpcRequest) {
	request = &CreateInstanceVpcEndpointLinkedVpcRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "CreateInstanceVpcEndpointLinkedVpc", "cr", "openAPI")
	return
}

// CreateCreateInstanceVpcEndpointLinkedVpcResponse creates a response to parse from CreateInstanceVpcEndpointLinkedVpc response
func CreateCreateInstanceVpcEndpointLinkedVpcResponse() (response *CreateInstanceVpcEndpointLinkedVpcResponse) {
	response = &CreateInstanceVpcEndpointLinkedVpcResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
