package crm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckLabel invokes the crm.CheckLabel API synchronously
// api document: https://help.aliyun.com/api/crm/checklabel.html
func (client *Client) CheckLabel(request *CheckLabelRequest) (response *CheckLabelResponse, err error) {
	response = CreateCheckLabelResponse()
	err = client.DoAction(request, response)
	return
}

// CheckLabelWithChan invokes the crm.CheckLabel API asynchronously
// api document: https://help.aliyun.com/api/crm/checklabel.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckLabelWithChan(request *CheckLabelRequest) (<-chan *CheckLabelResponse, <-chan error) {
	responseChan := make(chan *CheckLabelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckLabel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckLabelWithCallback invokes the crm.CheckLabel API asynchronously
// api document: https://help.aliyun.com/api/crm/checklabel.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckLabelWithCallback(request *CheckLabelRequest, callback func(response *CheckLabelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckLabelResponse
		var err error
		defer close(result)
		response, err = client.CheckLabel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckLabelRequest is the request struct for api CheckLabel
type CheckLabelRequest struct {
	*requests.RpcRequest
	LabelSeries string `position:"Query" name:"LabelSeries"`
	PK          string `position:"Query" name:"PK"`
	LabelName   string `position:"Query" name:"LabelName"`
}

// CheckLabelResponse is the response struct for api CheckLabel
type CheckLabelResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateCheckLabelRequest creates a request to invoke CheckLabel API
func CreateCheckLabelRequest() (request *CheckLabelRequest) {
	request = &CheckLabelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Crm", "2015-04-08", "CheckLabel", "crm", "openAPI")
	return
}

// CreateCheckLabelResponse creates a response to parse from CheckLabel response
func CreateCheckLabelResponse() (response *CheckLabelResponse) {
	response = &CheckLabelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
