package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VerifyContactField invokes the domain.VerifyContactField API synchronously
// api document: https://help.aliyun.com/api/domain/verifycontactfield.html
func (client *Client) VerifyContactField(request *VerifyContactFieldRequest) (response *VerifyContactFieldResponse, err error) {
	response = CreateVerifyContactFieldResponse()
	err = client.DoAction(request, response)
	return
}

// VerifyContactFieldWithChan invokes the domain.VerifyContactField API asynchronously
// api document: https://help.aliyun.com/api/domain/verifycontactfield.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) VerifyContactFieldWithChan(request *VerifyContactFieldRequest) (<-chan *VerifyContactFieldResponse, <-chan error) {
	responseChan := make(chan *VerifyContactFieldResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VerifyContactField(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VerifyContactFieldWithCallback invokes the domain.VerifyContactField API asynchronously
// api document: https://help.aliyun.com/api/domain/verifycontactfield.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) VerifyContactFieldWithCallback(request *VerifyContactFieldRequest, callback func(response *VerifyContactFieldResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VerifyContactFieldResponse
		var err error
		defer close(result)
		response, err = client.VerifyContactField(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VerifyContactFieldRequest is the request struct for api VerifyContactField
type VerifyContactFieldRequest struct {
	*requests.RpcRequest
	Country                  string `position:"Query" name:"Country"`
	Address                  string `position:"Query" name:"Address"`
	TelArea                  string `position:"Query" name:"TelArea"`
	City                     string `position:"Query" name:"City"`
	ZhAddress                string `position:"Query" name:"ZhAddress"`
	RegistrantType           string `position:"Query" name:"RegistrantType"`
	DomainName               string `position:"Query" name:"DomainName"`
	Telephone                string `position:"Query" name:"Telephone"`
	ZhCity                   string `position:"Query" name:"ZhCity"`
	ZhProvince               string `position:"Query" name:"ZhProvince"`
	RegistrantOrganization   string `position:"Query" name:"RegistrantOrganization"`
	TelExt                   string `position:"Query" name:"TelExt"`
	Province                 string `position:"Query" name:"Province"`
	ZhRegistrantName         string `position:"Query" name:"ZhRegistrantName"`
	PostalCode               string `position:"Query" name:"PostalCode"`
	UserClientIp             string `position:"Query" name:"UserClientIp"`
	Lang                     string `position:"Query" name:"Lang"`
	Email                    string `position:"Query" name:"Email"`
	RegistrantName           string `position:"Query" name:"RegistrantName"`
	ZhRegistrantOrganization string `position:"Query" name:"ZhRegistrantOrganization"`
}

// VerifyContactFieldResponse is the response struct for api VerifyContactField
type VerifyContactFieldResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateVerifyContactFieldRequest creates a request to invoke VerifyContactField API
func CreateVerifyContactFieldRequest() (request *VerifyContactFieldRequest) {
	request = &VerifyContactFieldRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "VerifyContactField", "", "")
	return
}

// CreateVerifyContactFieldResponse creates a response to parse from VerifyContactField response
func CreateVerifyContactFieldResponse() (response *VerifyContactFieldResponse) {
	response = &VerifyContactFieldResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
