package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRecycleBinStatus invokes the drds.DescribeRecycleBinStatus API synchronously
// api document: https://help.aliyun.com/api/drds/describerecyclebinstatus.html
func (client *Client) DescribeRecycleBinStatus(request *DescribeRecycleBinStatusRequest) (response *DescribeRecycleBinStatusResponse, err error) {
	response = CreateDescribeRecycleBinStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRecycleBinStatusWithChan invokes the drds.DescribeRecycleBinStatus API asynchronously
// api document: https://help.aliyun.com/api/drds/describerecyclebinstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeRecycleBinStatusWithChan(request *DescribeRecycleBinStatusRequest) (<-chan *DescribeRecycleBinStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeRecycleBinStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRecycleBinStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRecycleBinStatusWithCallback invokes the drds.DescribeRecycleBinStatus API asynchronously
// api document: https://help.aliyun.com/api/drds/describerecyclebinstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeRecycleBinStatusWithCallback(request *DescribeRecycleBinStatusRequest, callback func(response *DescribeRecycleBinStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRecycleBinStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeRecycleBinStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRecycleBinStatusRequest is the request struct for api DescribeRecycleBinStatus
type DescribeRecycleBinStatusRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	DbName         string `position:"Query" name:"DbName"`
}

// DescribeRecycleBinStatusResponse is the response struct for api DescribeRecycleBinStatus
type DescribeRecycleBinStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Status    string `json:"Status" xml:"Status"`
}

// CreateDescribeRecycleBinStatusRequest creates a request to invoke DescribeRecycleBinStatus API
func CreateDescribeRecycleBinStatusRequest() (request *DescribeRecycleBinStatusRequest) {
	request = &DescribeRecycleBinStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DescribeRecycleBinStatus", "Drds", "openAPI")
	return
}

// CreateDescribeRecycleBinStatusResponse creates a response to parse from DescribeRecycleBinStatus response
func CreateDescribeRecycleBinStatusResponse() (response *DescribeRecycleBinStatusResponse) {
	response = &DescribeRecycleBinStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
