package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableSqlAudit invokes the drds.DisableSqlAudit API synchronously
// api document: https://help.aliyun.com/api/drds/disablesqlaudit.html
func (client *Client) DisableSqlAudit(request *DisableSqlAuditRequest) (response *DisableSqlAuditResponse, err error) {
	response = CreateDisableSqlAuditResponse()
	err = client.DoAction(request, response)
	return
}

// DisableSqlAuditWithChan invokes the drds.DisableSqlAudit API asynchronously
// api document: https://help.aliyun.com/api/drds/disablesqlaudit.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DisableSqlAuditWithChan(request *DisableSqlAuditRequest) (<-chan *DisableSqlAuditResponse, <-chan error) {
	responseChan := make(chan *DisableSqlAuditResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableSqlAudit(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableSqlAuditWithCallback invokes the drds.DisableSqlAudit API asynchronously
// api document: https://help.aliyun.com/api/drds/disablesqlaudit.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DisableSqlAuditWithCallback(request *DisableSqlAuditRequest, callback func(response *DisableSqlAuditResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableSqlAuditResponse
		var err error
		defer close(result)
		response, err = client.DisableSqlAudit(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableSqlAuditRequest is the request struct for api DisableSqlAudit
type DisableSqlAuditRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	DbName         string `position:"Query" name:"DbName"`
}

// DisableSqlAuditResponse is the response struct for api DisableSqlAudit
type DisableSqlAuditResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateDisableSqlAuditRequest creates a request to invoke DisableSqlAudit API
func CreateDisableSqlAuditRequest() (request *DisableSqlAuditRequest) {
	request = &DisableSqlAuditRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DisableSqlAudit", "Drds", "openAPI")
	return
}

// CreateDisableSqlAuditResponse creates a response to parse from DisableSqlAudit response
func CreateDisableSqlAuditResponse() (response *DisableSqlAuditResponse) {
	response = &DisableSqlAuditResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
