package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ValidateShardTask invokes the drds.ValidateShardTask API synchronously
// api document: https://help.aliyun.com/api/drds/validateshardtask.html
func (client *Client) ValidateShardTask(request *ValidateShardTaskRequest) (response *ValidateShardTaskResponse, err error) {
	response = CreateValidateShardTaskResponse()
	err = client.DoAction(request, response)
	return
}

// ValidateShardTaskWithChan invokes the drds.ValidateShardTask API asynchronously
// api document: https://help.aliyun.com/api/drds/validateshardtask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ValidateShardTaskWithChan(request *ValidateShardTaskRequest) (<-chan *ValidateShardTaskResponse, <-chan error) {
	responseChan := make(chan *ValidateShardTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ValidateShardTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ValidateShardTaskWithCallback invokes the drds.ValidateShardTask API asynchronously
// api document: https://help.aliyun.com/api/drds/validateshardtask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ValidateShardTaskWithCallback(request *ValidateShardTaskRequest, callback func(response *ValidateShardTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ValidateShardTaskResponse
		var err error
		defer close(result)
		response, err = client.ValidateShardTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ValidateShardTaskRequest is the request struct for api ValidateShardTask
type ValidateShardTaskRequest struct {
	*requests.RpcRequest
	TaskType        string `position:"Query" name:"TaskType"`
	TargetTableName string `position:"Query" name:"TargetTableName"`
	DrdsInstanceId  string `position:"Query" name:"DrdsInstanceId"`
	DbName          string `position:"Query" name:"DbName"`
	SourceTableName string `position:"Query" name:"SourceTableName"`
}

// ValidateShardTaskResponse is the response struct for api ValidateShardTask
type ValidateShardTaskResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Success   bool       `json:"Success" xml:"Success"`
	List      []ListItem `json:"List" xml:"List"`
}

// CreateValidateShardTaskRequest creates a request to invoke ValidateShardTask API
func CreateValidateShardTaskRequest() (request *ValidateShardTaskRequest) {
	request = &ValidateShardTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "ValidateShardTask", "Drds", "openAPI")
	return
}

// CreateValidateShardTaskResponse creates a response to parse from ValidateShardTask response
func CreateValidateShardTaskResponse() (response *ValidateShardTaskResponse) {
	response = &ValidateShardTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
