package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRobotTask invokes the dyvmsapi.DeleteRobotTask API synchronously
// api document: https://help.aliyun.com/api/dyvmsapi/deleterobottask.html
func (client *Client) DeleteRobotTask(request *DeleteRobotTaskRequest) (response *DeleteRobotTaskResponse, err error) {
	response = CreateDeleteRobotTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRobotTaskWithChan invokes the dyvmsapi.DeleteRobotTask API asynchronously
// api document: https://help.aliyun.com/api/dyvmsapi/deleterobottask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteRobotTaskWithChan(request *DeleteRobotTaskRequest) (<-chan *DeleteRobotTaskResponse, <-chan error) {
	responseChan := make(chan *DeleteRobotTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRobotTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRobotTaskWithCallback invokes the dyvmsapi.DeleteRobotTask API asynchronously
// api document: https://help.aliyun.com/api/dyvmsapi/deleterobottask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteRobotTaskWithCallback(request *DeleteRobotTaskRequest, callback func(response *DeleteRobotTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRobotTaskResponse
		var err error
		defer close(result)
		response, err = client.DeleteRobotTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRobotTaskRequest is the request struct for api DeleteRobotTask
type DeleteRobotTaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TaskId               requests.Integer `position:"Query" name:"TaskId"`
}

// DeleteRobotTaskResponse is the response struct for api DeleteRobotTask
type DeleteRobotTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDeleteRobotTaskRequest creates a request to invoke DeleteRobotTask API
func CreateDeleteRobotTaskRequest() (request *DeleteRobotTaskRequest) {
	request = &DeleteRobotTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "DeleteRobotTask", "dyvms", "openAPI")
	return
}

// CreateDeleteRobotTaskResponse creates a response to parse from DeleteRobotTask response
func CreateDeleteRobotTaskResponse() (response *DeleteRobotTaskResponse) {
	response = &DeleteRobotTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
