package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterServiceConfigForAdmin invokes the emr.DescribeClusterServiceConfigForAdmin API synchronously
// api document: https://help.aliyun.com/api/emr/describeclusterserviceconfigforadmin.html
func (client *Client) DescribeClusterServiceConfigForAdmin(request *DescribeClusterServiceConfigForAdminRequest) (response *DescribeClusterServiceConfigForAdminResponse, err error) {
	response = CreateDescribeClusterServiceConfigForAdminResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterServiceConfigForAdminWithChan invokes the emr.DescribeClusterServiceConfigForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/describeclusterserviceconfigforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterServiceConfigForAdminWithChan(request *DescribeClusterServiceConfigForAdminRequest) (<-chan *DescribeClusterServiceConfigForAdminResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterServiceConfigForAdminResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterServiceConfigForAdmin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterServiceConfigForAdminWithCallback invokes the emr.DescribeClusterServiceConfigForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/describeclusterserviceconfigforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterServiceConfigForAdminWithCallback(request *DescribeClusterServiceConfigForAdminRequest, callback func(response *DescribeClusterServiceConfigForAdminResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterServiceConfigForAdminResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterServiceConfigForAdmin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterServiceConfigForAdminRequest is the request struct for api DescribeClusterServiceConfigForAdmin
type DescribeClusterServiceConfigForAdminRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HostInstanceId  string           `position:"Query" name:"HostInstanceId"`
	TagValue        string           `position:"Query" name:"TagValue"`
	GroupId         string           `position:"Query" name:"GroupId"`
	ServiceName     string           `position:"Query" name:"ServiceName"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	UserId          string           `position:"Query" name:"UserId"`
	ConfigVersion   string           `position:"Query" name:"ConfigVersion"`
}

// DescribeClusterServiceConfigForAdminResponse is the response struct for api DescribeClusterServiceConfigForAdmin
type DescribeClusterServiceConfigForAdminResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Config    Config `json:"Config" xml:"Config"`
}

// CreateDescribeClusterServiceConfigForAdminRequest creates a request to invoke DescribeClusterServiceConfigForAdmin API
func CreateDescribeClusterServiceConfigForAdminRequest() (request *DescribeClusterServiceConfigForAdminRequest) {
	request = &DescribeClusterServiceConfigForAdminRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeClusterServiceConfigForAdmin", "emr", "openAPI")
	return
}

// CreateDescribeClusterServiceConfigForAdminResponse creates a response to parse from DescribeClusterServiceConfigForAdmin response
func CreateDescribeClusterServiceConfigForAdminResponse() (response *DescribeClusterServiceConfigForAdminResponse) {
	response = &DescribeClusterServiceConfigForAdminResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
