package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeHostPool invokes the emr.DescribeHostPool API synchronously
// api document: https://help.aliyun.com/api/emr/describehostpool.html
func (client *Client) DescribeHostPool(request *DescribeHostPoolRequest) (response *DescribeHostPoolResponse, err error) {
	response = CreateDescribeHostPoolResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeHostPoolWithChan invokes the emr.DescribeHostPool API asynchronously
// api document: https://help.aliyun.com/api/emr/describehostpool.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeHostPoolWithChan(request *DescribeHostPoolRequest) (<-chan *DescribeHostPoolResponse, <-chan error) {
	responseChan := make(chan *DescribeHostPoolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeHostPool(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeHostPoolWithCallback invokes the emr.DescribeHostPool API asynchronously
// api document: https://help.aliyun.com/api/emr/describehostpool.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeHostPoolWithCallback(request *DescribeHostPoolRequest, callback func(response *DescribeHostPoolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeHostPoolResponse
		var err error
		defer close(result)
		response, err = client.DescribeHostPool(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeHostPoolRequest is the request struct for api DescribeHostPool
type DescribeHostPoolRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	BizId           string           `position:"Query" name:"BizId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// DescribeHostPoolResponse is the response struct for api DescribeHostPool
type DescribeHostPoolResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	Name        string `json:"Name" xml:"Name"`
	BizId       string `json:"BizId" xml:"BizId"`
	Status      string `json:"Status" xml:"Status"`
	Type        string `json:"Type" xml:"Type"`
	Description string `json:"Description" xml:"Description"`
	HostCount   int    `json:"HostCount" xml:"HostCount"`
	GmtCreate   int64  `json:"GmtCreate" xml:"GmtCreate"`
}

// CreateDescribeHostPoolRequest creates a request to invoke DescribeHostPool API
func CreateDescribeHostPoolRequest() (request *DescribeHostPoolRequest) {
	request = &DescribeHostPoolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeHostPool", "emr", "openAPI")
	return
}

// CreateDescribeHostPoolResponse creates a response to parse from DescribeHostPool response
func CreateDescribeHostPoolResponse() (response *DescribeHostPoolResponse) {
	response = &DescribeHostPoolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
