package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOpsCommandResult invokes the emr.GetOpsCommandResult API synchronously
// api document: https://help.aliyun.com/api/emr/getopscommandresult.html
func (client *Client) GetOpsCommandResult(request *GetOpsCommandResultRequest) (response *GetOpsCommandResultResponse, err error) {
	response = CreateGetOpsCommandResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetOpsCommandResultWithChan invokes the emr.GetOpsCommandResult API asynchronously
// api document: https://help.aliyun.com/api/emr/getopscommandresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOpsCommandResultWithChan(request *GetOpsCommandResultRequest) (<-chan *GetOpsCommandResultResponse, <-chan error) {
	responseChan := make(chan *GetOpsCommandResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOpsCommandResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOpsCommandResultWithCallback invokes the emr.GetOpsCommandResult API asynchronously
// api document: https://help.aliyun.com/api/emr/getopscommandresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOpsCommandResultWithCallback(request *GetOpsCommandResultRequest, callback func(response *GetOpsCommandResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOpsCommandResultResponse
		var err error
		defer close(result)
		response, err = client.GetOpsCommandResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOpsCommandResultRequest is the request struct for api GetOpsCommandResult
type GetOpsCommandResultRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	EndCursor       requests.Integer `position:"Query" name:"EndCursor"`
	StartCursor     requests.Integer `position:"Query" name:"StartCursor"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	TaskId          requests.Integer `position:"Query" name:"TaskId"`
}

// GetOpsCommandResultResponse is the response struct for api GetOpsCommandResult
type GetOpsCommandResultResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Content   string `json:"Content" xml:"Content"`
	Cursor    int64  `json:"Cursor" xml:"Cursor"`
	Finished  bool   `json:"Finished" xml:"Finished"`
}

// CreateGetOpsCommandResultRequest creates a request to invoke GetOpsCommandResult API
func CreateGetOpsCommandResultRequest() (request *GetOpsCommandResultRequest) {
	request = &GetOpsCommandResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "GetOpsCommandResult", "emr", "openAPI")
	return
}

// CreateGetOpsCommandResultResponse creates a response to parse from GetOpsCommandResult response
func CreateGetOpsCommandResultResponse() (response *GetOpsCommandResultResponse) {
	response = &GetOpsCommandResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
