package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListClusterServiceCustomActionSupportConfigForAdmin invokes the emr.ListClusterServiceCustomActionSupportConfigForAdmin API synchronously
// api document: https://help.aliyun.com/api/emr/listclusterservicecustomactionsupportconfigforadmin.html
func (client *Client) ListClusterServiceCustomActionSupportConfigForAdmin(request *ListClusterServiceCustomActionSupportConfigForAdminRequest) (response *ListClusterServiceCustomActionSupportConfigForAdminResponse, err error) {
	response = CreateListClusterServiceCustomActionSupportConfigForAdminResponse()
	err = client.DoAction(request, response)
	return
}

// ListClusterServiceCustomActionSupportConfigForAdminWithChan invokes the emr.ListClusterServiceCustomActionSupportConfigForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/listclusterservicecustomactionsupportconfigforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListClusterServiceCustomActionSupportConfigForAdminWithChan(request *ListClusterServiceCustomActionSupportConfigForAdminRequest) (<-chan *ListClusterServiceCustomActionSupportConfigForAdminResponse, <-chan error) {
	responseChan := make(chan *ListClusterServiceCustomActionSupportConfigForAdminResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListClusterServiceCustomActionSupportConfigForAdmin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListClusterServiceCustomActionSupportConfigForAdminWithCallback invokes the emr.ListClusterServiceCustomActionSupportConfigForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/listclusterservicecustomactionsupportconfigforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListClusterServiceCustomActionSupportConfigForAdminWithCallback(request *ListClusterServiceCustomActionSupportConfigForAdminRequest, callback func(response *ListClusterServiceCustomActionSupportConfigForAdminResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListClusterServiceCustomActionSupportConfigForAdminResponse
		var err error
		defer close(result)
		response, err = client.ListClusterServiceCustomActionSupportConfigForAdmin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListClusterServiceCustomActionSupportConfigForAdminRequest is the request struct for api ListClusterServiceCustomActionSupportConfigForAdmin
type ListClusterServiceCustomActionSupportConfigForAdminRequest struct {
	*requests.RpcRequest
	ServiceCustomActionName string           `position:"Query" name:"ServiceCustomActionName"`
	ResourceOwnerId         requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ServiceName             string           `position:"Query" name:"ServiceName"`
	ClusterId               string           `position:"Query" name:"ClusterId"`
	UserId                  string           `position:"Query" name:"UserId"`
}

// ListClusterServiceCustomActionSupportConfigForAdminResponse is the response struct for api ListClusterServiceCustomActionSupportConfigForAdmin
type ListClusterServiceCustomActionSupportConfigForAdminResponse struct {
	*responses.BaseResponse
	RequestId           string                                                                   `json:"RequestId" xml:"RequestId"`
	SupportedConfigList SupportedConfigListInListClusterServiceCustomActionSupportConfigForAdmin `json:"SupportedConfigList" xml:"SupportedConfigList"`
}

// CreateListClusterServiceCustomActionSupportConfigForAdminRequest creates a request to invoke ListClusterServiceCustomActionSupportConfigForAdmin API
func CreateListClusterServiceCustomActionSupportConfigForAdminRequest() (request *ListClusterServiceCustomActionSupportConfigForAdminRequest) {
	request = &ListClusterServiceCustomActionSupportConfigForAdminRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListClusterServiceCustomActionSupportConfigForAdmin", "emr", "openAPI")
	return
}

// CreateListClusterServiceCustomActionSupportConfigForAdminResponse creates a response to parse from ListClusterServiceCustomActionSupportConfigForAdmin response
func CreateListClusterServiceCustomActionSupportConfigForAdminResponse() (response *ListClusterServiceCustomActionSupportConfigForAdminResponse) {
	response = &ListClusterServiceCustomActionSupportConfigForAdminResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
