package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListResourcePoolForAdmin invokes the emr.ListResourcePoolForAdmin API synchronously
// api document: https://help.aliyun.com/api/emr/listresourcepoolforadmin.html
func (client *Client) ListResourcePoolForAdmin(request *ListResourcePoolForAdminRequest) (response *ListResourcePoolForAdminResponse, err error) {
	response = CreateListResourcePoolForAdminResponse()
	err = client.DoAction(request, response)
	return
}

// ListResourcePoolForAdminWithChan invokes the emr.ListResourcePoolForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/listresourcepoolforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListResourcePoolForAdminWithChan(request *ListResourcePoolForAdminRequest) (<-chan *ListResourcePoolForAdminResponse, <-chan error) {
	responseChan := make(chan *ListResourcePoolForAdminResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListResourcePoolForAdmin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListResourcePoolForAdminWithCallback invokes the emr.ListResourcePoolForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/listresourcepoolforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListResourcePoolForAdminWithCallback(request *ListResourcePoolForAdminRequest, callback func(response *ListResourcePoolForAdminResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListResourcePoolForAdminResponse
		var err error
		defer close(result)
		response, err = client.ListResourcePoolForAdmin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListResourcePoolForAdminRequest is the request struct for api ListResourcePoolForAdmin
type ListResourcePoolForAdminRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	UserId          string           `position:"Query" name:"UserId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	PoolType        string           `position:"Query" name:"PoolType"`
}

// ListResourcePoolForAdminResponse is the response struct for api ListResourcePoolForAdmin
type ListResourcePoolForAdminResponse struct {
	*responses.BaseResponse
	RequestId    string                                 `json:"RequestId" xml:"RequestId"`
	PageNumber   int                                    `json:"PageNumber" xml:"PageNumber"`
	PageSize     int                                    `json:"PageSize" xml:"PageSize"`
	Total        int                                    `json:"Total" xml:"Total"`
	PoolInfoList PoolInfoListInListResourcePoolForAdmin `json:"PoolInfoList" xml:"PoolInfoList"`
}

// CreateListResourcePoolForAdminRequest creates a request to invoke ListResourcePoolForAdmin API
func CreateListResourcePoolForAdminRequest() (request *ListResourcePoolForAdminRequest) {
	request = &ListResourcePoolForAdminRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListResourcePoolForAdmin", "emr", "openAPI")
	return
}

// CreateListResourcePoolForAdminResponse creates a response to parse from ListResourcePoolForAdmin response
func CreateListResourcePoolForAdminResponse() (response *ListResourcePoolForAdminResponse) {
	response = &ListResourcePoolForAdminResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
