package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyFlow invokes the emr.ModifyFlow API synchronously
// api document: https://help.aliyun.com/api/emr/modifyflow.html
func (client *Client) ModifyFlow(request *ModifyFlowRequest) (response *ModifyFlowResponse, err error) {
	response = CreateModifyFlowResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyFlowWithChan invokes the emr.ModifyFlow API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyflow.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyFlowWithChan(request *ModifyFlowRequest) (<-chan *ModifyFlowResponse, <-chan error) {
	responseChan := make(chan *ModifyFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyFlowWithCallback invokes the emr.ModifyFlow API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyflow.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyFlowWithCallback(request *ModifyFlowRequest, callback func(response *ModifyFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyFlowResponse
		var err error
		defer close(result)
		response, err = client.ModifyFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyFlowRequest is the request struct for api ModifyFlow
type ModifyFlowRequest struct {
	*requests.RpcRequest
	CronExpr                string           `position:"Query" name:"CronExpr"`
	ParentFlowList          string           `position:"Query" name:"ParentFlowList"`
	AlertDingDingGroupBizId string           `position:"Query" name:"AlertDingDingGroupBizId"`
	Periodic                requests.Boolean `position:"Query" name:"Periodic"`
	StartSchedule           requests.Integer `position:"Query" name:"StartSchedule"`
	Description             string           `position:"Query" name:"Description"`
	ClusterId               string           `position:"Query" name:"ClusterId"`
	AlertUserGroupBizId     string           `position:"Query" name:"AlertUserGroupBizId"`
	HostName                string           `position:"Query" name:"HostName"`
	Application             string           `position:"Query" name:"Application"`
	CreateCluster           requests.Boolean `position:"Query" name:"CreateCluster"`
	Name                    string           `position:"Query" name:"Name"`
	EndSchedule             requests.Integer `position:"Query" name:"EndSchedule"`
	Id                      string           `position:"Query" name:"Id"`
	AlertConf               string           `position:"Query" name:"AlertConf"`
	ProjectId               string           `position:"Query" name:"ProjectId"`
	Status                  string           `position:"Query" name:"Status"`
	ParentCategory          string           `position:"Query" name:"ParentCategory"`
}

// ModifyFlowResponse is the response struct for api ModifyFlow
type ModifyFlowResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateModifyFlowRequest creates a request to invoke ModifyFlow API
func CreateModifyFlowRequest() (request *ModifyFlowRequest) {
	request = &ModifyFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyFlow", "emr", "openAPI")
	return
}

// CreateModifyFlowResponse creates a response to parse from ModifyFlow response
func CreateModifyFlowResponse() (response *ModifyFlowResponse) {
	response = &ModifyFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
