package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RefreshClusterResourcePoolForAdmin invokes the emr.RefreshClusterResourcePoolForAdmin API synchronously
// api document: https://help.aliyun.com/api/emr/refreshclusterresourcepoolforadmin.html
func (client *Client) RefreshClusterResourcePoolForAdmin(request *RefreshClusterResourcePoolForAdminRequest) (response *RefreshClusterResourcePoolForAdminResponse, err error) {
	response = CreateRefreshClusterResourcePoolForAdminResponse()
	err = client.DoAction(request, response)
	return
}

// RefreshClusterResourcePoolForAdminWithChan invokes the emr.RefreshClusterResourcePoolForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/refreshclusterresourcepoolforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RefreshClusterResourcePoolForAdminWithChan(request *RefreshClusterResourcePoolForAdminRequest) (<-chan *RefreshClusterResourcePoolForAdminResponse, <-chan error) {
	responseChan := make(chan *RefreshClusterResourcePoolForAdminResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RefreshClusterResourcePoolForAdmin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RefreshClusterResourcePoolForAdminWithCallback invokes the emr.RefreshClusterResourcePoolForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/refreshclusterresourcepoolforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RefreshClusterResourcePoolForAdminWithCallback(request *RefreshClusterResourcePoolForAdminRequest, callback func(response *RefreshClusterResourcePoolForAdminResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RefreshClusterResourcePoolForAdminResponse
		var err error
		defer close(result)
		response, err = client.RefreshClusterResourcePoolForAdmin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RefreshClusterResourcePoolForAdminRequest is the request struct for api RefreshClusterResourcePoolForAdmin
type RefreshClusterResourcePoolForAdminRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourcePoolId  requests.Integer `position:"Query" name:"ResourcePoolId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	UserId          string           `position:"Query" name:"UserId"`
}

// RefreshClusterResourcePoolForAdminResponse is the response struct for api RefreshClusterResourcePoolForAdmin
type RefreshClusterResourcePoolForAdminResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	WorkFlowInstanceId string `json:"WorkFlowInstanceId" xml:"WorkFlowInstanceId"`
	OperationId        string `json:"OperationId" xml:"OperationId"`
}

// CreateRefreshClusterResourcePoolForAdminRequest creates a request to invoke RefreshClusterResourcePoolForAdmin API
func CreateRefreshClusterResourcePoolForAdminRequest() (request *RefreshClusterResourcePoolForAdminRequest) {
	request = &RefreshClusterResourcePoolForAdminRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "RefreshClusterResourcePoolForAdmin", "emr", "openAPI")
	return
}

// CreateRefreshClusterResourcePoolForAdminResponse creates a response to parse from RefreshClusterResourcePoolForAdmin response
func CreateRefreshClusterResourcePoolForAdminResponse() (response *RefreshClusterResourcePoolForAdminResponse) {
	response = &RefreshClusterResourcePoolForAdminResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
