package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RenderResourcePoolXmlForAdmin invokes the emr.RenderResourcePoolXmlForAdmin API synchronously
// api document: https://help.aliyun.com/api/emr/renderresourcepoolxmlforadmin.html
func (client *Client) RenderResourcePoolXmlForAdmin(request *RenderResourcePoolXmlForAdminRequest) (response *RenderResourcePoolXmlForAdminResponse, err error) {
	response = CreateRenderResourcePoolXmlForAdminResponse()
	err = client.DoAction(request, response)
	return
}

// RenderResourcePoolXmlForAdminWithChan invokes the emr.RenderResourcePoolXmlForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/renderresourcepoolxmlforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RenderResourcePoolXmlForAdminWithChan(request *RenderResourcePoolXmlForAdminRequest) (<-chan *RenderResourcePoolXmlForAdminResponse, <-chan error) {
	responseChan := make(chan *RenderResourcePoolXmlForAdminResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RenderResourcePoolXmlForAdmin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RenderResourcePoolXmlForAdminWithCallback invokes the emr.RenderResourcePoolXmlForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/renderresourcepoolxmlforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RenderResourcePoolXmlForAdminWithCallback(request *RenderResourcePoolXmlForAdminRequest, callback func(response *RenderResourcePoolXmlForAdminResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RenderResourcePoolXmlForAdminResponse
		var err error
		defer close(result)
		response, err = client.RenderResourcePoolXmlForAdmin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RenderResourcePoolXmlForAdminRequest is the request struct for api RenderResourcePoolXmlForAdmin
type RenderResourcePoolXmlForAdminRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourcePoolId  string           `position:"Query" name:"ResourcePoolId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	UserId          string           `position:"Query" name:"UserId"`
}

// RenderResourcePoolXmlForAdminResponse is the response struct for api RenderResourcePoolXmlForAdmin
type RenderResourcePoolXmlForAdminResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	XmlContent string `json:"XmlContent" xml:"XmlContent"`
}

// CreateRenderResourcePoolXmlForAdminRequest creates a request to invoke RenderResourcePoolXmlForAdmin API
func CreateRenderResourcePoolXmlForAdminRequest() (request *RenderResourcePoolXmlForAdminRequest) {
	request = &RenderResourcePoolXmlForAdminRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "RenderResourcePoolXmlForAdmin", "emr", "openAPI")
	return
}

// CreateRenderResourcePoolXmlForAdminResponse creates a response to parse from RenderResourcePoolXmlForAdmin response
func CreateRenderResourcePoolXmlForAdminResponse() (response *RenderResourcePoolXmlForAdminResponse) {
	response = &RenderResourcePoolXmlForAdminResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
