package fnf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReportTaskFailed invokes the fnf.ReportTaskFailed API synchronously
// api document: https://help.aliyun.com/api/fnf/reporttaskfailed.html
func (client *Client) ReportTaskFailed(request *ReportTaskFailedRequest) (response *ReportTaskFailedResponse, err error) {
	response = CreateReportTaskFailedResponse()
	err = client.DoAction(request, response)
	return
}

// ReportTaskFailedWithChan invokes the fnf.ReportTaskFailed API asynchronously
// api document: https://help.aliyun.com/api/fnf/reporttaskfailed.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ReportTaskFailedWithChan(request *ReportTaskFailedRequest) (<-chan *ReportTaskFailedResponse, <-chan error) {
	responseChan := make(chan *ReportTaskFailedResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReportTaskFailed(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReportTaskFailedWithCallback invokes the fnf.ReportTaskFailed API asynchronously
// api document: https://help.aliyun.com/api/fnf/reporttaskfailed.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ReportTaskFailedWithCallback(request *ReportTaskFailedRequest, callback func(response *ReportTaskFailedResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReportTaskFailedResponse
		var err error
		defer close(result)
		response, err = client.ReportTaskFailed(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReportTaskFailedRequest is the request struct for api ReportTaskFailed
type ReportTaskFailedRequest struct {
	*requests.RpcRequest
	RequestId string `position:"Query" name:"RequestId"`
	Cause     string `position:"Body" name:"Cause"`
	TaskToken string `position:"Query" name:"TaskToken"`
	Error     string `position:"Body" name:"Error"`
}

// ReportTaskFailedResponse is the response struct for api ReportTaskFailed
type ReportTaskFailedResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	EventId   int64  `json:"EventId" xml:"EventId"`
}

// CreateReportTaskFailedRequest creates a request to invoke ReportTaskFailed API
func CreateReportTaskFailedRequest() (request *ReportTaskFailedRequest) {
	request = &ReportTaskFailedRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("fnf", "2019-03-15", "ReportTaskFailed", "fnf", "openAPI")
	return
}

// CreateReportTaskFailedResponse creates a response to parse from ReportTaskFailed response
func CreateReportTaskFailedResponse() (response *ReportTaskFailedResponse) {
	response = &ReportTaskFailedResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
