package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceDetail invokes the foas.GetInstanceDetail API synchronously
// api document: https://help.aliyun.com/api/foas/getinstancedetail.html
func (client *Client) GetInstanceDetail(request *GetInstanceDetailRequest) (response *GetInstanceDetailResponse, err error) {
	response = CreateGetInstanceDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceDetailWithChan invokes the foas.GetInstanceDetail API asynchronously
// api document: https://help.aliyun.com/api/foas/getinstancedetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetInstanceDetailWithChan(request *GetInstanceDetailRequest) (<-chan *GetInstanceDetailResponse, <-chan error) {
	responseChan := make(chan *GetInstanceDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceDetailWithCallback invokes the foas.GetInstanceDetail API asynchronously
// api document: https://help.aliyun.com/api/foas/getinstancedetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetInstanceDetailWithCallback(request *GetInstanceDetailRequest, callback func(response *GetInstanceDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceDetailResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceDetailRequest is the request struct for api GetInstanceDetail
type GetInstanceDetailRequest struct {
	*requests.RoaRequest
	ProjectName string           `position:"Path" name:"projectName"`
	InstanceId  requests.Integer `position:"Path" name:"instanceId"`
	JobName     string           `position:"Path" name:"jobName"`
}

// GetInstanceDetailResponse is the response struct for api GetInstanceDetail
type GetInstanceDetailResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Detail    string `json:"Detail" xml:"Detail"`
}

// CreateGetInstanceDetailRequest creates a request to invoke GetInstanceDetail API
func CreateGetInstanceDetailRequest() (request *GetInstanceDetailRequest) {
	request = &GetInstanceDetailRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "GetInstanceDetail", "/api/v2/projects/[projectName]/jobs/[jobName]/instances/[instanceId]/details", "foas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetInstanceDetailResponse creates a response to parse from GetInstanceDetail response
func CreateGetInstanceDetailResponse() (response *GetInstanceDetailResponse) {
	response = &GetInstanceDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
