package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNotificationSetting invokes the green.DescribeNotificationSetting API synchronously
// api document: https://help.aliyun.com/api/green/describenotificationsetting.html
func (client *Client) DescribeNotificationSetting(request *DescribeNotificationSettingRequest) (response *DescribeNotificationSettingResponse, err error) {
	response = CreateDescribeNotificationSettingResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNotificationSettingWithChan invokes the green.DescribeNotificationSetting API asynchronously
// api document: https://help.aliyun.com/api/green/describenotificationsetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeNotificationSettingWithChan(request *DescribeNotificationSettingRequest) (<-chan *DescribeNotificationSettingResponse, <-chan error) {
	responseChan := make(chan *DescribeNotificationSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNotificationSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNotificationSettingWithCallback invokes the green.DescribeNotificationSetting API asynchronously
// api document: https://help.aliyun.com/api/green/describenotificationsetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeNotificationSettingWithCallback(request *DescribeNotificationSettingRequest, callback func(response *DescribeNotificationSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNotificationSettingResponse
		var err error
		defer close(result)
		response, err = client.DescribeNotificationSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNotificationSettingRequest is the request struct for api DescribeNotificationSetting
type DescribeNotificationSettingRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeNotificationSettingResponse is the response struct for api DescribeNotificationSetting
type DescribeNotificationSettingResponse struct {
	*responses.BaseResponse
	RequestId               string   `json:"RequestId" xml:"RequestId"`
	Email                   string   `json:"Email" xml:"Email"`
	Phone                   string   `json:"Phone" xml:"Phone"`
	ScheduleMessageTime     int      `json:"ScheduleMessageTime" xml:"ScheduleMessageTime"`
	ScheduleMessageTimeZone int      `json:"ScheduleMessageTimeZone" xml:"ScheduleMessageTimeZone"`
	RealtimeMessageList     []string `json:"RealtimeMessageList" xml:"RealtimeMessageList"`
	ReminderModeList        []string `json:"ReminderModeList" xml:"ReminderModeList"`
}

// CreateDescribeNotificationSettingRequest creates a request to invoke DescribeNotificationSetting API
func CreateDescribeNotificationSettingRequest() (request *DescribeNotificationSettingRequest) {
	request = &DescribeNotificationSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "DescribeNotificationSetting", "green", "openAPI")
	return
}

// CreateDescribeNotificationSettingResponse creates a response to parse from DescribeNotificationSetting response
func CreateDescribeNotificationSettingResponse() (response *DescribeNotificationSettingResponse) {
	response = &DescribeNotificationSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
