package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOpenApiUsage invokes the green.DescribeOpenApiUsage API synchronously
// api document: https://help.aliyun.com/api/green/describeopenapiusage.html
func (client *Client) DescribeOpenApiUsage(request *DescribeOpenApiUsageRequest) (response *DescribeOpenApiUsageResponse, err error) {
	response = CreateDescribeOpenApiUsageResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOpenApiUsageWithChan invokes the green.DescribeOpenApiUsage API asynchronously
// api document: https://help.aliyun.com/api/green/describeopenapiusage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOpenApiUsageWithChan(request *DescribeOpenApiUsageRequest) (<-chan *DescribeOpenApiUsageResponse, <-chan error) {
	responseChan := make(chan *DescribeOpenApiUsageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOpenApiUsage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOpenApiUsageWithCallback invokes the green.DescribeOpenApiUsage API asynchronously
// api document: https://help.aliyun.com/api/green/describeopenapiusage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOpenApiUsageWithCallback(request *DescribeOpenApiUsageRequest, callback func(response *DescribeOpenApiUsageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOpenApiUsageResponse
		var err error
		defer close(result)
		response, err = client.DescribeOpenApiUsage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOpenApiUsageRequest is the request struct for api DescribeOpenApiUsage
type DescribeOpenApiUsageRequest struct {
	*requests.RpcRequest
	StartDate    string `position:"Query" name:"StartDate"`
	ResourceType string `position:"Query" name:"ResourceType"`
	EndDate      string `position:"Query" name:"EndDate"`
	SourceIp     string `position:"Query" name:"SourceIp"`
}

// DescribeOpenApiUsageResponse is the response struct for api DescribeOpenApiUsage
type DescribeOpenApiUsageResponse struct {
	*responses.BaseResponse
	RequestId        string         `json:"RequestId" xml:"RequestId"`
	TotalCount       int            `json:"TotalCount" xml:"TotalCount"`
	OpenApiUsageList []OpenApiUsage `json:"OpenApiUsageList" xml:"OpenApiUsageList"`
}

// CreateDescribeOpenApiUsageRequest creates a request to invoke DescribeOpenApiUsage API
func CreateDescribeOpenApiUsageRequest() (request *DescribeOpenApiUsageRequest) {
	request = &DescribeOpenApiUsageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "DescribeOpenApiUsage", "green", "openAPI")
	return
}

// CreateDescribeOpenApiUsageResponse creates a response to parse from DescribeOpenApiUsage response
func CreateDescribeOpenApiUsageResponse() (response *DescribeOpenApiUsageResponse) {
	response = &DescribeOpenApiUsageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
