package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOssIncrementCheckSetting invokes the green.DescribeOssIncrementCheckSetting API synchronously
// api document: https://help.aliyun.com/api/green/describeossincrementchecksetting.html
func (client *Client) DescribeOssIncrementCheckSetting(request *DescribeOssIncrementCheckSettingRequest) (response *DescribeOssIncrementCheckSettingResponse, err error) {
	response = CreateDescribeOssIncrementCheckSettingResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOssIncrementCheckSettingWithChan invokes the green.DescribeOssIncrementCheckSetting API asynchronously
// api document: https://help.aliyun.com/api/green/describeossincrementchecksetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOssIncrementCheckSettingWithChan(request *DescribeOssIncrementCheckSettingRequest) (<-chan *DescribeOssIncrementCheckSettingResponse, <-chan error) {
	responseChan := make(chan *DescribeOssIncrementCheckSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOssIncrementCheckSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOssIncrementCheckSettingWithCallback invokes the green.DescribeOssIncrementCheckSetting API asynchronously
// api document: https://help.aliyun.com/api/green/describeossincrementchecksetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOssIncrementCheckSettingWithCallback(request *DescribeOssIncrementCheckSettingRequest, callback func(response *DescribeOssIncrementCheckSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOssIncrementCheckSettingResponse
		var err error
		defer close(result)
		response, err = client.DescribeOssIncrementCheckSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOssIncrementCheckSettingRequest is the request struct for api DescribeOssIncrementCheckSetting
type DescribeOssIncrementCheckSettingRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeOssIncrementCheckSettingResponse is the response struct for api DescribeOssIncrementCheckSetting
type DescribeOssIncrementCheckSettingResponse struct {
	*responses.BaseResponse
	RequestId                string          `json:"RequestId" xml:"RequestId"`
	ImageEnableLimit         bool            `json:"ImageEnableLimit" xml:"ImageEnableLimit"`
	ImageScanLimit           int64           `json:"ImageScanLimit" xml:"ImageScanLimit"`
	VideoFrameInterval       int             `json:"VideoFrameInterval" xml:"VideoFrameInterval"`
	VideoMaxFrames           int             `json:"VideoMaxFrames" xml:"VideoMaxFrames"`
	VideoMaxSize             int             `json:"VideoMaxSize" xml:"VideoMaxSize"`
	AutoFreezeType           string          `json:"AutoFreezeType" xml:"AutoFreezeType"`
	ImageSceneList           []string        `json:"ImageSceneList" xml:"ImageSceneList"`
	VideoSceneList           []string        `json:"VideoSceneList" xml:"VideoSceneList"`
	VideoAutoFreezeSceneList []string        `json:"VideoAutoFreezeSceneList" xml:"VideoAutoFreezeSceneList"`
	ImageAutoFreeze          ImageAutoFreeze `json:"ImageAutoFreeze" xml:"ImageAutoFreeze"`
	BucketConfigList         []BucketConfig  `json:"BucketConfigList" xml:"BucketConfigList"`
}

// CreateDescribeOssIncrementCheckSettingRequest creates a request to invoke DescribeOssIncrementCheckSetting API
func CreateDescribeOssIncrementCheckSettingRequest() (request *DescribeOssIncrementCheckSettingRequest) {
	request = &DescribeOssIncrementCheckSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "DescribeOssIncrementCheckSetting", "green", "openAPI")
	return
}

// CreateDescribeOssIncrementCheckSettingResponse creates a response to parse from DescribeOssIncrementCheckSetting response
func CreateDescribeOssIncrementCheckSettingResponse() (response *DescribeOssIncrementCheckSettingResponse) {
	response = &DescribeOssIncrementCheckSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
