package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWebsiteScanResult invokes the green.DescribeWebsiteScanResult API synchronously
// api document: https://help.aliyun.com/api/green/describewebsitescanresult.html
func (client *Client) DescribeWebsiteScanResult(request *DescribeWebsiteScanResultRequest) (response *DescribeWebsiteScanResultResponse, err error) {
	response = CreateDescribeWebsiteScanResultResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWebsiteScanResultWithChan invokes the green.DescribeWebsiteScanResult API asynchronously
// api document: https://help.aliyun.com/api/green/describewebsitescanresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWebsiteScanResultWithChan(request *DescribeWebsiteScanResultRequest) (<-chan *DescribeWebsiteScanResultResponse, <-chan error) {
	responseChan := make(chan *DescribeWebsiteScanResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWebsiteScanResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWebsiteScanResultWithCallback invokes the green.DescribeWebsiteScanResult API asynchronously
// api document: https://help.aliyun.com/api/green/describewebsitescanresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWebsiteScanResultWithCallback(request *DescribeWebsiteScanResultRequest, callback func(response *DescribeWebsiteScanResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWebsiteScanResultResponse
		var err error
		defer close(result)
		response, err = client.DescribeWebsiteScanResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWebsiteScanResultRequest is the request struct for api DescribeWebsiteScanResult
type DescribeWebsiteScanResultRequest struct {
	*requests.RpcRequest
	SubServiceModule string           `position:"Query" name:"SubServiceModule"`
	SourceIp         string           `position:"Query" name:"SourceIp"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	Lang             string           `position:"Query" name:"Lang"`
	TotalCount       requests.Integer `position:"Query" name:"TotalCount"`
	SiteUrl          string           `position:"Query" name:"SiteUrl"`
	HandleStatus     string           `position:"Query" name:"HandleStatus"`
	CurrentPage      requests.Integer `position:"Query" name:"CurrentPage"`
	Label            string           `position:"Query" name:"Label"`
	Domain           string           `position:"Query" name:"Domain"`
}

// DescribeWebsiteScanResultResponse is the response struct for api DescribeWebsiteScanResult
type DescribeWebsiteScanResultResponse struct {
	*responses.BaseResponse
	RequestId             string              `json:"RequestId" xml:"RequestId"`
	PageSize              int                 `json:"PageSize" xml:"PageSize"`
	CurrentPage           int                 `json:"CurrentPage" xml:"CurrentPage"`
	TotalCount            int                 `json:"TotalCount" xml:"TotalCount"`
	WebsiteScanResultList []WebsiteScanResult `json:"WebsiteScanResultList" xml:"WebsiteScanResultList"`
}

// CreateDescribeWebsiteScanResultRequest creates a request to invoke DescribeWebsiteScanResult API
func CreateDescribeWebsiteScanResultRequest() (request *DescribeWebsiteScanResultRequest) {
	request = &DescribeWebsiteScanResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "DescribeWebsiteScanResult", "green", "openAPI")
	return
}

// CreateDescribeWebsiteScanResultResponse creates a response to parse from DescribeWebsiteScanResult response
func CreateDescribeWebsiteScanResultResponse() (response *DescribeWebsiteScanResultResponse) {
	response = &DescribeWebsiteScanResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
