package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveDomainDetail invokes the live.DescribeLiveDomainDetail API synchronously
// api document: https://help.aliyun.com/api/live/describelivedomaindetail.html
func (client *Client) DescribeLiveDomainDetail(request *DescribeLiveDomainDetailRequest) (response *DescribeLiveDomainDetailResponse, err error) {
	response = CreateDescribeLiveDomainDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveDomainDetailWithChan invokes the live.DescribeLiveDomainDetail API asynchronously
// api document: https://help.aliyun.com/api/live/describelivedomaindetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveDomainDetailWithChan(request *DescribeLiveDomainDetailRequest) (<-chan *DescribeLiveDomainDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveDomainDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveDomainDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveDomainDetailWithCallback invokes the live.DescribeLiveDomainDetail API asynchronously
// api document: https://help.aliyun.com/api/live/describelivedomaindetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveDomainDetailWithCallback(request *DescribeLiveDomainDetailRequest, callback func(response *DescribeLiveDomainDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveDomainDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveDomainDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveDomainDetailRequest is the request struct for api DescribeLiveDomainDetail
type DescribeLiveDomainDetailRequest struct {
	*requests.RpcRequest
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// DescribeLiveDomainDetailResponse is the response struct for api DescribeLiveDomainDetail
type DescribeLiveDomainDetailResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	DomainDetail DomainDetail `json:"DomainDetail" xml:"DomainDetail"`
}

// CreateDescribeLiveDomainDetailRequest creates a request to invoke DescribeLiveDomainDetail API
func CreateDescribeLiveDomainDetailRequest() (request *DescribeLiveDomainDetailRequest) {
	request = &DescribeLiveDomainDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveDomainDetail", "live", "openAPI")
	return
}

// CreateDescribeLiveDomainDetailResponse creates a response to parse from DescribeLiveDomainDetail response
func CreateDescribeLiveDomainDetailResponse() (response *DescribeLiveDomainDetailResponse) {
	response = &DescribeLiveDomainDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
