package multimediaai

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLabelTask invokes the multimediaai.CreateLabelTask API synchronously
// api document: https://help.aliyun.com/api/multimediaai/createlabeltask.html
func (client *Client) CreateLabelTask(request *CreateLabelTaskRequest) (response *CreateLabelTaskResponse, err error) {
	response = CreateCreateLabelTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLabelTaskWithChan invokes the multimediaai.CreateLabelTask API asynchronously
// api document: https://help.aliyun.com/api/multimediaai/createlabeltask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateLabelTaskWithChan(request *CreateLabelTaskRequest) (<-chan *CreateLabelTaskResponse, <-chan error) {
	responseChan := make(chan *CreateLabelTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLabelTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLabelTaskWithCallback invokes the multimediaai.CreateLabelTask API asynchronously
// api document: https://help.aliyun.com/api/multimediaai/createlabeltask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateLabelTaskWithCallback(request *CreateLabelTaskRequest, callback func(response *CreateLabelTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLabelTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateLabelTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLabelTaskRequest is the request struct for api CreateLabelTask
type CreateLabelTaskRequest struct {
	*requests.RpcRequest
	TemplateId    requests.Integer `position:"Query" name:"TemplateId"`
	VideoUrl      string           `position:"Query" name:"VideoUrl"`
	VideoName     string           `position:"Query" name:"VideoName"`
	CallbackUrl   string           `position:"Query" name:"CallbackUrl"`
	ApplicationId string           `position:"Query" name:"ApplicationId"`
}

// CreateLabelTaskResponse is the response struct for api CreateLabelTask
type CreateLabelTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskId    int64  `json:"TaskId" xml:"TaskId"`
}

// CreateCreateLabelTaskRequest creates a request to invoke CreateLabelTask API
func CreateCreateLabelTaskRequest() (request *CreateLabelTaskRequest) {
	request = &CreateLabelTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("multimediaai", "2019-08-10", "CreateLabelTask", "multimediaai", "openAPI")
	return
}

// CreateCreateLabelTaskResponse creates a response to parse from CreateLabelTask response
func CreateCreateLabelTaskResponse() (response *CreateLabelTaskResponse) {
	response = &CreateLabelTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
