//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package nas

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAccessGroup invokes the nas.DeleteAccessGroup API synchronously
// api document: https://help.aliyun.com/api/nas/deleteaccessgroup.html
func (client *Client) DeleteAccessGroup(request *DeleteAccessGroupRequest) (response *DeleteAccessGroupResponse, err error) {
	response = CreateDeleteAccessGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAccessGroupWithChan invokes the nas.DeleteAccessGroup API asynchronously
// api document: https://help.aliyun.com/api/nas/deleteaccessgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteAccessGroupWithChan(request *DeleteAccessGroupRequest) (<-chan *DeleteAccessGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteAccessGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAccessGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAccessGroupWithCallback invokes the nas.DeleteAccessGroup API asynchronously
// api document: https://help.aliyun.com/api/nas/deleteaccessgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteAccessGroupWithCallback(request *DeleteAccessGroupRequest, callback func(response *DeleteAccessGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAccessGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteAccessGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAccessGroupRequest is the request struct for api DeleteAccessGroup
type DeleteAccessGroupRequest struct {
	*requests.RpcRequest
	AccessGroupName string `position:"Query" name:"AccessGroupName"`
	FileSystemType  string `position:"Query" name:"FileSystemType"`
}

// DeleteAccessGroupResponse is the response struct for api DeleteAccessGroup
type DeleteAccessGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteAccessGroupRequest creates a request to invoke DeleteAccessGroup API
func CreateDeleteAccessGroupRequest() (request *DeleteAccessGroupRequest) {
	request = &DeleteAccessGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "DeleteAccessGroup", "nas", "openAPI")
	return
}

// CreateDeleteAccessGroupResponse creates a response to parse from DeleteAccessGroup response
func CreateDeleteAccessGroupResponse() (response *DeleteAccessGroupResponse) {
	response = &DeleteAccessGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
