package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTaskAssignRule invokes the qualitycheck.DeleteTaskAssignRule API synchronously
// api document: https://help.aliyun.com/api/qualitycheck/deletetaskassignrule.html
func (client *Client) DeleteTaskAssignRule(request *DeleteTaskAssignRuleRequest) (response *DeleteTaskAssignRuleResponse, err error) {
	response = CreateDeleteTaskAssignRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTaskAssignRuleWithChan invokes the qualitycheck.DeleteTaskAssignRule API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/deletetaskassignrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteTaskAssignRuleWithChan(request *DeleteTaskAssignRuleRequest) (<-chan *DeleteTaskAssignRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteTaskAssignRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTaskAssignRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTaskAssignRuleWithCallback invokes the qualitycheck.DeleteTaskAssignRule API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/deletetaskassignrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteTaskAssignRuleWithCallback(request *DeleteTaskAssignRuleRequest, callback func(response *DeleteTaskAssignRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTaskAssignRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteTaskAssignRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTaskAssignRuleRequest is the request struct for api DeleteTaskAssignRule
type DeleteTaskAssignRuleRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// DeleteTaskAssignRuleResponse is the response struct for api DeleteTaskAssignRule
type DeleteTaskAssignRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDeleteTaskAssignRuleRequest creates a request to invoke DeleteTaskAssignRule API
func CreateDeleteTaskAssignRuleRequest() (request *DeleteTaskAssignRuleRequest) {
	request = &DeleteTaskAssignRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "DeleteTaskAssignRule", "", "")
	return
}

// CreateDeleteTaskAssignRuleResponse creates a response to parse from DeleteTaskAssignRule response
func CreateDeleteTaskAssignRuleResponse() (response *DeleteTaskAssignRuleResponse) {
	response = &DeleteTaskAssignRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
