package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSnapshotSettings invokes the r_kvstore.DeleteSnapshotSettings API synchronously
// api document: https://help.aliyun.com/api/r-kvstore/deletesnapshotsettings.html
func (client *Client) DeleteSnapshotSettings(request *DeleteSnapshotSettingsRequest) (response *DeleteSnapshotSettingsResponse, err error) {
	response = CreateDeleteSnapshotSettingsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSnapshotSettingsWithChan invokes the r_kvstore.DeleteSnapshotSettings API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/deletesnapshotsettings.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteSnapshotSettingsWithChan(request *DeleteSnapshotSettingsRequest) (<-chan *DeleteSnapshotSettingsResponse, <-chan error) {
	responseChan := make(chan *DeleteSnapshotSettingsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSnapshotSettings(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSnapshotSettingsWithCallback invokes the r_kvstore.DeleteSnapshotSettings API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/deletesnapshotsettings.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteSnapshotSettingsWithCallback(request *DeleteSnapshotSettingsRequest, callback func(response *DeleteSnapshotSettingsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSnapshotSettingsResponse
		var err error
		defer close(result)
		response, err = client.DeleteSnapshotSettings(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSnapshotSettingsRequest is the request struct for api DeleteSnapshotSettings
type DeleteSnapshotSettingsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteSnapshotSettingsResponse is the response struct for api DeleteSnapshotSettings
type DeleteSnapshotSettingsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteSnapshotSettingsRequest creates a request to invoke DeleteSnapshotSettings API
func CreateDeleteSnapshotSettingsRequest() (request *DeleteSnapshotSettingsRequest) {
	request = &DeleteSnapshotSettingsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "DeleteSnapshotSettings", "", "")
	return
}

// CreateDeleteSnapshotSettingsResponse creates a response to parse from DeleteSnapshotSettings response
func CreateDeleteSnapshotSettingsResponse() (response *DeleteSnapshotSettingsResponse) {
	response = &DeleteSnapshotSettingsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
